/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import rtg.api.RTGAPI;
import rtg.api.util.CircularSearchCreator;
import rtg.api.util.Logger;
import rtg.api.util.storage.SparseList;
import rtg.api.world.biome.IRealisticBiome;
import rtg.world.gen.ChunkLandscape;

public final class BiomeAnalyzer {
    private static final int NO_BIOME = -1;
    private static final int RIVER_FLAG = 1;
    private static final int OCEAN_FLAG = 2;
    private static final int SWAMP_FLAG = 4;
    private static final int BEACH_FLAG = 8;
    private static final int LAND_FLAG = 16;
    private final List<Integer> biomeIDs = new SparseList<Integer>();
    private final List<Integer> preferredBeach = new SparseList<Integer>();
    private final IRealisticBiome scenicLakeBiome = RTGAPI.getRTGBiome(Biomes.field_76781_i);
    private final IRealisticBiome scenicFrozenLakeBiome = RTGAPI.getRTGBiome(Biomes.field_76777_m);
    private SmoothingSearchStatus beachSearch;
    private SmoothingSearchStatus landSearch;
    private SmoothingSearchStatus oceanSearch;

    public BiomeAnalyzer() {
        this.initBiomes();
        this.setupBeachesForBiomes();
        this.setSearches();
    }

    public int[] xyinverted() {
        int i;
        int[] result = new int[256];
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                result[i * 16 + j] = j * 16 + i;
            }
        }
        for (i = 0; i < 256; ++i) {
            if (result[result[i]] == i) continue;
            throw new RuntimeException(i + " " + result[i] + " " + result[result[i]]);
        }
        return result;
    }

    private void initBiomes() {
        Logger.rtgDebug("Initialising biomes.", new Object[0]);
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            int id = Biome.func_185362_a((Biome)biome);
            Integer biomeFlags = this.biomeIDs.get(id);
            biomeFlags = biomeFlags == null ? 0 : biomeFlags;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                biomeFlags = biomeFlags | 1;
                Logger.rtgDebug("Assigning " + biome.getRegistryName() + " to river flag.", new Object[0]);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                biomeFlags = biomeFlags | 2;
                Logger.rtgDebug("Assigning " + biome.getRegistryName() + " to ocean flag.", new Object[0]);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                biomeFlags = biomeFlags | 4;
                Logger.rtgDebug("Assigning " + biome.getRegistryName() + " to swamp flag.", new Object[0]);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                biomeFlags = biomeFlags | 8;
                Logger.rtgDebug("Assigning " + biome.getRegistryName() + " to beach flag.", new Object[0]);
            } else {
                biomeFlags = biomeFlags | 0x10;
                Logger.rtgDebug("Assigning " + biome.getRegistryName() + " to land flag.", new Object[0]);
            }
            this.biomeIDs.set(id, biomeFlags);
        }
    }

    private void setupBeachesForBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            int id;
            Map.Entry<Biome, IRealisticBiome> realisticBiome;
            if (biome == null || (realisticBiome = RTGAPI.RTG_BIOMES.get(id = Biome.func_185362_a((Biome)biome))) == null) continue;
            this.preferredBeach.set(id, realisticBiome.getValue().getBeachBiome().baseBiomeId());
        }
    }

    public void newRepair(SparseList<Biome> genLayerBiomes, int[] biomeNeighborhood, ChunkLandscape landscape) {
        int biomeFlags;
        int foundBiome;
        int biomeID;
        int i;
        List<IRealisticBiome> jitteredBiomes = landscape.biome;
        float[] noise = landscape.noise;
        float[] riverStrength = landscape.river;
        for (int i2 = 0; i2 < genLayerBiomes.size(); ++i2) {
            boolean canBeRiver;
            IRealisticBiome realisticBiome = RTGAPI.getRTGBiome(genLayerBiomes.get(i2));
            int realisticBiomeId = realisticBiome.baseBiomeId();
            boolean bl = canBeRiver = (double)riverStrength[i2] > 0.7;
            if ((double)noise[i2] > 61.5) {
                jitteredBiomes.set(i2, realisticBiome);
                continue;
            }
            int biomeFlags2 = this.biomeIDs.get(realisticBiomeId);
            if (canBeRiver && (biomeFlags2 & 2) == 0 && (biomeFlags2 & 4) == 0) {
                jitteredBiomes.set(i2, realisticBiome.getRiverBiome());
                continue;
            }
            jitteredBiomes.set(i2, realisticBiome);
        }
        this.beachSearch.setNotHunted();
        this.beachSearch.setAbsent();
        float beachTop = 64.5f;
        for (i = 0; i < genLayerBiomes.size() && !this.beachSearch.isAbsent(); ++i) {
            float beachBottom = 61.5f;
            if (noise[i] < beachBottom || noise[i] > this.riverAdjusted(beachTop, riverStrength[i]) || (this.biomeIDs.get(biomeID = Biome.func_185362_a((Biome)jitteredBiomes.get(i).baseBiome())) & 4) != 0) continue;
            if (this.beachSearch.isNotHunted()) {
                this.beachSearch.hunt(biomeNeighborhood);
                this.landSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome = this.beachSearch.biomeIDs.get(i).intValue()) == -1) continue;
            int nearestLandBiome = this.landSearch.biomeIDs.get(i);
            if (nearestLandBiome > -1) {
                foundBiome = this.preferredBeach.get(nearestLandBiome);
            }
            jitteredBiomes.set(i, RTGAPI.getRTGBiome(foundBiome));
        }
        this.landSearch.setAbsent();
        this.landSearch.setNotHunted();
        for (i = 0; !(i >= genLayerBiomes.size() || this.landSearch.isAbsent() && this.beachSearch.isAbsent()); ++i) {
            int biomeID2;
            if (noise[i] < this.riverAdjusted(beachTop, riverStrength[i]) || ((biomeFlags = this.biomeIDs.get(biomeID2 = Biome.func_185362_a((Biome)jitteredBiomes.get(i).baseBiome())).intValue()) & 0x10) != 0 || (biomeFlags & 4) != 0) continue;
            if (this.landSearch.isNotHunted()) {
                this.landSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome = this.landSearch.biomeIDs.get(i).intValue()) == -1) {
                if (this.beachSearch.isNotHunted()) {
                    this.beachSearch.hunt(biomeNeighborhood);
                }
                foundBiome = this.beachSearch.biomeIDs.get(i);
            }
            if (foundBiome == -1) continue;
            jitteredBiomes.set(i, RTGAPI.getRTGBiome(foundBiome));
        }
        this.oceanSearch.setAbsent();
        this.oceanSearch.setNotHunted();
        for (i = 0; i < genLayerBiomes.size() && !this.oceanSearch.isAbsent(); ++i) {
            int foundBiome2;
            int biomeFlags3;
            float oceanTop = 61.5f;
            if (noise[i] > oceanTop || ((biomeFlags3 = this.biomeIDs.get(biomeID = Biome.func_185362_a((Biome)jitteredBiomes.get(i).baseBiome())).intValue()) & 2) != 0 || (biomeFlags3 & 4) != 0 || (biomeFlags3 & 1) != 0) continue;
            if (this.oceanSearch.isNotHunted()) {
                this.oceanSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome2 = this.oceanSearch.biomeIDs.get(i).intValue()) == -1) continue;
            jitteredBiomes.set(i, RTGAPI.getRTGBiome(foundBiome2));
        }
        for (i = 0; i < genLayerBiomes.size(); ++i) {
            int biomeID3 = Biome.func_185362_a((Biome)jitteredBiomes.get(i).baseBiome());
            biomeFlags = this.biomeIDs.get(biomeID3);
            if (!((double)noise[i] <= 61.5) || (biomeFlags & 1) != 0 || (biomeFlags & 2) != 0 || (biomeFlags & 4) != 0 || (biomeFlags & 8) != 0) continue;
            int riverReplacementID = jitteredBiomes.get(i).getRiverBiome().baseBiomeId();
            if (riverReplacementID == Biome.func_185362_a((Biome)Biomes.field_76777_m)) {
                jitteredBiomes.set(i, this.scenicFrozenLakeBiome);
                continue;
            }
            jitteredBiomes.set(i, this.scenicLakeBiome);
        }
    }

    private List<Boolean> filterForFlag(int flag) {
        SparseList<Boolean> result = new SparseList<Boolean>();
        for (Integer biomeId : this.biomeIDs) {
            if (biomeId == null) continue;
            result.set((int)biomeId, (biomeId & flag) != 0);
        }
        return result;
    }

    private void setSearches() {
        this.beachSearch = new SmoothingSearchStatus(this.filterForFlag(8));
        this.landSearch = new SmoothingSearchStatus(this.filterForFlag(16));
        this.oceanSearch = new SmoothingSearchStatus(this.filterForFlag(2));
    }

    private float riverAdjusted(float top, float river) {
        if (river >= 1.0f) {
            return top;
        }
        float erodedRiver = river / 0.09375f;
        if (erodedRiver <= 1.0f) {
            top = top * (1.0f - erodedRiver) + 62.0f * erodedRiver;
        }
        top = top * (1.0f - river) + 62.0f * river;
        return top;
    }

    private static final class SmoothingSearchStatus {
        private final int upperLeftFinding = 0;
        private final int upperRightFinding = 3;
        private final int lowerLeftFinding = 1;
        private final int lowerRightFinding = 4;
        private final int[] quadrantBiome = new int[4];
        private final float[] quadrantBiomeWeighting = new float[4];
        private final List<Boolean> desired;
        private final int[] findings = new int[9];
        private final float[] weightings = new float[9];
        public List<Integer> biomeIDs = new SparseList<Integer>();
        private boolean absent = false;
        private boolean notHunted;
        private int arraySize;
        private int[] pattern;
        private int biomeCount;

        private SmoothingSearchStatus(List<Boolean> desired) {
            this.desired = desired;
        }

        private int size() {
            return 3;
        }

        private void hunt(int[] biomeNeighborhood) {
            this.clear();
            int oldArraySize = this.arraySize;
            this.arraySize = (int)Math.sqrt(biomeNeighborhood.length);
            if (this.arraySize * this.arraySize != biomeNeighborhood.length) {
                throw new RuntimeException("non-square array");
            }
            if (this.arraySize != oldArraySize) {
                this.pattern = new CircularSearchCreator().pattern((float)this.arraySize / 2.0f - 1.0f, this.arraySize);
            }
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    this.search(xOffset, zOffset, biomeNeighborhood);
                }
            }
            this.smoothBiomes();
        }

        private void search(int xOffset, int zOffset, int[] biomeNeighborhood) {
            int offset = xOffset * this.arraySize + zOffset;
            int location = (xOffset + 1) * this.size() + zOffset + 1;
            this.findings[location] = -1;
            this.weightings[location] = 2.0f;
            for (int i = 0; i < this.pattern.length; ++i) {
                int biome = biomeNeighborhood[this.pattern[i] + offset];
                Boolean d = this.desired.get(biome);
                d = d != null && d != false;
                if (!d.booleanValue() || !this.desired.get(biome).booleanValue()) continue;
                this.findings[location] = biome;
                this.weightings[location] = (float)Math.sqrt(this.pattern.length) - (float)Math.sqrt(i) + 2.0f;
                break;
            }
        }

        private void smoothBiomes() {
            this.smoothQuadrant(this.biomeIndex(0, 0), 0);
            this.smoothQuadrant(this.biomeIndex(8, 0), 3);
            this.smoothQuadrant(this.biomeIndex(0, 8), 1);
            this.smoothQuadrant(this.biomeIndex(8, 8), 4);
        }

        private void smoothQuadrant(int biomesOffset, int findingsOffset) {
            int upperLeft = this.findings[0 + findingsOffset];
            int upperRight = this.findings[3 + findingsOffset];
            int lowerLeft = this.findings[1 + findingsOffset];
            int lowerRight = this.findings[4 + findingsOffset];
            if (upperLeft == upperRight && upperLeft == lowerLeft && upperLeft == lowerRight) {
                for (int x = 0; x < 8; ++x) {
                    for (int z = 0; z < 8; ++z) {
                        this.biomeIDs.set(this.biomeIndex(x, z) + biomesOffset, upperLeft);
                    }
                }
                return;
            }
            this.biomeCount = 0;
            this.addBiome(upperLeft);
            this.addBiome(upperRight);
            this.addBiome(lowerLeft);
            this.addBiome(lowerRight);
            for (int x = 0; x < 8; ++x) {
                for (int z = 0; z < 8; ++z) {
                    this.addBiome(lowerRight);
                    for (int i = 0; i < 4; ++i) {
                        this.quadrantBiomeWeighting[i] = 0.0f;
                    }
                    this.addWeight(upperLeft, this.weightings[0 + findingsOffset] * (float)(7 - x) * (float)(7 - z));
                    this.addWeight(upperRight, this.weightings[3 + findingsOffset] * (float)x * (float)(7 - z));
                    this.addWeight(lowerLeft, this.weightings[1 + findingsOffset] * (float)(7 - x) * (float)z);
                    this.addWeight(lowerRight, this.weightings[4 + findingsOffset] * (float)x * (float)z);
                    this.biomeIDs.set(this.biomeIndex(x, z) + biomesOffset, this.preferredBiome());
                }
            }
        }

        private void addBiome(int biome) {
            for (int i = 0; i < this.biomeCount; ++i) {
                if (biome != this.quadrantBiome[i]) continue;
                return;
            }
            this.quadrantBiome[this.biomeCount++] = biome;
        }

        private void addWeight(int biome, float weight) {
            for (int i = 0; i < this.biomeCount; ++i) {
                if (biome != this.quadrantBiome[i]) continue;
                int n = i;
                this.quadrantBiomeWeighting[n] = this.quadrantBiomeWeighting[n] + weight;
                return;
            }
        }

        private int preferredBiome() {
            float bestWeight = 0.0f;
            int result = -2;
            for (int i = 0; i < this.biomeCount; ++i) {
                if (!(this.quadrantBiomeWeighting[i] > bestWeight)) continue;
                bestWeight = this.quadrantBiomeWeighting[i];
                result = this.quadrantBiome[i];
            }
            return result;
        }

        private int biomeIndex(int x, int z) {
            return x * 16 + z;
        }

        private void clear() {
            Arrays.fill(this.findings, -1);
        }

        private boolean isAbsent() {
            return this.absent;
        }

        private void setAbsent() {
            this.absent = false;
        }

        private boolean isNotHunted() {
            return this.notHunted;
        }

        private void setNotHunted() {
            this.notHunted = true;
        }
    }
}

