/*
 * Decompiled with CFR 0.152.
 */
package rtg.event;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import rtg.RTGConfig;
import rtg.api.RTGAPI;
import rtg.api.util.BlockUtil;
import rtg.api.util.Logger;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;
import rtg.world.biome.BiomeProviderRTG;

public final class EventHandlerCommon {
    private EventHandlerCommon() {
    }

    public static void init() {
        MinecraftForge.TERRAIN_GEN_BUS.register(EventHandlerCommon.class);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDecorateBiome(DecorateBiomeEvent.Decorate event) {
        DecorateBiomeEvent.Decorate.EventType eventType;
        World world = event.getWorld();
        if (world.func_72959_q() instanceof BiomeProviderRTG && ((eventType = event.getType()) == DecorateBiomeEvent.Decorate.EventType.LAKE_WATER || eventType == DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
            event.setResult(Event.Result.DENY);
            EventHandlerCommon.generateFalls(world, event.getRand(), event.getChunkPos(), eventType);
        }
    }

    private static void generateFalls(World world, Random rand, ChunkPos chunkPos, DecorateBiomeEvent.Decorate.EventType type) {
        BlockPos offsetpos = new BlockPos(chunkPos.field_77276_a * 16 + 8, 0, chunkPos.field_77275_b * 16 + 8);
        switch (type) {
            case LAKE_WATER: {
                for (int i = 0; i < 20; ++i) {
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(world, rand, offsetpos.func_177982_a(rand.nextInt(16), rand.nextInt(64) + 8, rand.nextInt(16)));
                }
                break;
            }
            case LAKE_LAVA: {
                for (int i = 0; i < 5; ++i) {
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(world, rand, offsetpos.func_177982_a(rand.nextInt(16), rand.nextInt(rand.nextInt(rand.nextInt(64) + 8) + 8), rand.nextInt(16)));
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public static void saplingGrowTreeRTG(SaplingGrowTreeEvent event) {
        int treeHeight;
        int chance;
        World world = event.getWorld();
        if (!RTGConfig.rtgTreesFromSaplings() || !(world.func_72959_q() instanceof BiomeProviderRTG)) {
            Logger.debug("[SaplingGrowTreeEvent] Aborting: RTG trees are disabled, or not an RTG dimension", new Object[0]);
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState saplingBlock = world.func_180495_p(pos);
        Logger.trace("Handling SaplingGrowTreeEvent in dim: {}, at: {}, for: {}", world.field_73011_w.getDimension(), pos, saplingBlock);
        if (!(saplingBlock.func_177230_c() instanceof BlockSapling)) {
            Logger.debug("[SaplingGrowTreeEvent] Aborting: Sapling is not a sapling block ({})", saplingBlock.func_177230_c().getClass().getName());
            return;
        }
        Random rand = event.getRand();
        if (rand.nextInt((chance = RTGConfig.rtgTreeChance()) < 1 ? 1 : chance) != 0) {
            Logger.debug("[SaplingGrowTreeEvent] Aborting RTG tree generation: random chance", new Object[0]);
            return;
        }
        IRealisticBiome rtgBiome = RTGAPI.getRTGBiome(world.func_180494_b(pos));
        Collection<TreeRTG> biomeTrees = rtgBiome.getTrees();
        if (biomeTrees.isEmpty()) {
            Logger.debug("[SaplingGrowTreeEvent] Aborting RTG tree generation: No RTG trees to generate in Biome: {}", rtgBiome.baseBiomeResLoc());
            return;
        }
        List validTrees = biomeTrees.stream().filter(tree -> saplingBlock.func_177230_c() == tree.getSaplingBlock().func_177230_c() && BlockUtil.getTypeFromSapling(saplingBlock) == BlockUtil.getTypeFromSapling(tree.getSaplingBlock())).collect(Collectors.toList());
        if (validTrees.isEmpty()) {
            Logger.debug("[SaplingGrowTreeEvent] No RTG trees found for sapling, so generating original tree instead", new Object[0]);
            return;
        }
        TreeRTG tree2 = (TreeRTG)((Object)validTrees.get(rand.nextInt(validTrees.size())));
        if (tree2.getMinTrunkSize() > 0 && tree2.getMaxTrunkSize() > tree2.getMinTrunkSize()) {
            tree2.setTrunkSize(DecoBase.getRangedRandom(rand, tree2.getMinTrunkSize(), tree2.getMaxTrunkSize()));
        }
        if (tree2.getMinCrownSize() > 0 && tree2.getMaxCrownSize() > tree2.getMinCrownSize()) {
            tree2.setCrownSize(DecoBase.getRangedRandom(rand, tree2.getMinCrownSize(), tree2.getMaxCrownSize()));
        }
        if ((treeHeight = tree2.getTrunkSize() + tree2.getCrownSize()) < 1) {
            Logger.debug("[SaplingGrowTreeEvent] Unable to grow RTG tree with no height: {}[logblock={}, leafblock={}, saplingblock={}]", ((Object)((Object)tree2)).getClass().getSimpleName(), tree2.getLogBlock(), tree2.getLeavesBlock(), tree2.getSaplingBlock());
            return;
        }
        if (!BlockUtil.checkVerticalMaterials(BlockUtil.MatchType.ALL_IGNORE_REPLACEABLE, world, pos.func_177984_a(), treeHeight - 1, new Material[0])) {
            Logger.debug("[SaplingGrowTreeEvent] Aborting RTG tree generation: not enough space above", new Object[0]);
            return;
        }
        int oldFlag = tree2.getGenerateFlag();
        tree2.setGenerateFlag(3);
        boolean generated = tree2.func_180709_b(world, rand, pos);
        tree2.setGenerateFlag(oldFlag);
        if (generated) {
            event.setResult(Event.Result.DENY);
            if (world.func_180495_p(pos) == saplingBlock) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
        Logger.trace("Finished handling SaplingGrowTreeEvent in Biome: {}, with sapling: {}", rtgBiome.baseBiomeResLoc(), saplingBlock);
    }
}

