/*
 * Decompiled with CFR 0.152.
 */
package rtg.compat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import rtg.RTGConfig;
import rtg.api.RTGAPI;
import rtg.api.util.Logger;

public final class ModCompat {
    private static final int ID_LENGTH = 3;
    private static final String ID_FORMAT = "%3s";
    private static final int NAME_LENGTH = 32;
    private static final String NAME_FORMAT = "%-32s";
    private static final int RESLOC_LENGTH = 50;
    private static final String RESLOC_FORMAT = "%-50s";
    private static final int BIOME_NAME_LENGTH = 24;
    private static final String BIOME_NAME_FORMAT = "%-24s";
    private static final int BIOME_CLASS_LENGTH = 32;
    private static final String BIOME_CLASS_FORMAT = "%-32s";
    private static final int BIOME_RESLOC_LENGTH = 44;
    private static final String BIOME_RESLOC_FORMAT = "%-44s";
    private static final int BEACH_NAME_LENGTH = 24;
    private static final String BEACH_NAME_FORMAT = "%-24s";

    private ModCompat() {
    }

    public static void doBiomeCheck() {
        Collection supportedBiomes;
        Biome biome;
        ArrayList invalidBiomes = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76778_j, Biomes.field_76779_k, Biomes.field_185440_P});
        if (Mods.abyssalcraft.isLoaded()) {
            invalidBiomes.addAll(Stream.of(Mods.abyssalcraft.getResourceLocation("abyssal_wastelands"), Mods.abyssalcraft.getResourceLocation("dark_realm"), Mods.abyssalcraft.getResourceLocation("dreadlands"), Mods.abyssalcraft.getResourceLocation("dreadlands_forest"), Mods.abyssalcraft.getResourceLocation("dreadlands_mountains"), Mods.abyssalcraft.getResourceLocation("omothol"), Mods.abyssalcraft.getResourceLocation("purified_dreadlands"), Mods.abyssalcraft.getResourceLocation("purged")).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (Mods.biomesoplenty.isLoaded()) {
            invalidBiomes.addAll(Stream.of(Mods.biomesoplenty.getResourceLocation("corrupted_sands"), Mods.biomesoplenty.getResourceLocation("fungi_forest"), Mods.biomesoplenty.getResourceLocation("phantasmagoric_inferno"), Mods.biomesoplenty.getResourceLocation("undergarden"), Mods.biomesoplenty.getResourceLocation("visceral_heap")).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (Mods.byg.isLoaded()) {
            invalidBiomes.addAll(Stream.of(Mods.byg.getResourceLocation("babyssalbog"), Mods.byg.getResourceLocation("bastralisle"), Mods.byg.getResourceLocation("bcosmicocean"), Mods.byg.getResourceLocation("bshattereddesert")).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (Mods.fyrecraft.isLoaded()) {
            invalidBiomes.addAll(Stream.of(Mods.fyrecraft.getResourceLocation("miner's caves"), Mods.fyrecraft.getResourceLocation("waterfalls")).map(arg_0 -> ((RegistryNamespaced)Biome.field_185377_q).func_82594_a(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (Mods.thaumcraft.isLoaded() && (biome = (Biome)ForgeRegistries.BIOMES.getValue(Mods.thaumcraft.getResourceLocation("eldritch"))) != null) {
            invalidBiomes.add(biome);
        }
        RTGConfig.getBlacklistMods().stream().filter(Loader::isModLoaded).map(modId -> ForgeRegistries.BIOMES.getValuesCollection().stream().filter(biome -> biome.getRegistryName().func_110624_b().equals(modId)).collect(Collectors.toList())).flatMap(Collection::stream).forEach(invalidBiomes::add);
        Collection unsupportedBiomes = ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !invalidBiomes.contains(b) && !RTGAPI.RTG_BIOMES.containsKey(Biome.func_185362_a((Biome)b))).sorted(Comparator.comparingInt(Biome::func_185362_a)).collect(Collectors.toList());
        if (!unsupportedBiomes.isEmpty()) {
            Logger.warn(".= " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '=')) + " = " + String.format("%-32s", new String(new char[32]).replace('\u0000', '=')) + " = " + String.format(RESLOC_FORMAT, new String(new char[50]).replace('\u0000', '=')) + " =.", new Object[0]);
            Logger.warn("|| " + String.format("%-91s", "                RTG could not find realistic versions of the following biomes") + " ||", new Object[0]);
            Logger.warn("|| " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '=')) + " = " + String.format("%-32s", new String(new char[32]).replace('\u0000', '=')) + " = " + String.format(RESLOC_FORMAT, new String(new char[50]).replace('\u0000', '=')) + " ||", new Object[0]);
            Logger.warn("|| " + String.format(ID_FORMAT, "ID") + " | " + String.format("%-32s", "Biome Class") + " | " + String.format(RESLOC_FORMAT, "Registry Name") + " ||", new Object[0]);
            Logger.warn("|| " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '-')) + " - " + String.format("%-32s", new String(new char[32]).replace('\u0000', '-')) + " - " + String.format(RESLOC_FORMAT, new String(new char[50]).replace('\u0000', '-')) + " ||", new Object[0]);
            unsupportedBiomes.forEach(b -> Logger.warn("|| " + String.format(ID_FORMAT, Biome.func_185362_a((Biome)b)) + " | " + String.format("%-32s", b.func_150562_l().getSimpleName()) + " | " + String.format(RESLOC_FORMAT, b.getRegistryName()) + " ||", new Object[0]));
            Logger.warn("`= " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '=')) + " | " + String.format("%-32s", new String(new char[32]).replace('\u0000', '=')) + " | " + String.format(RESLOC_FORMAT, new String(new char[50]).replace('\u0000', '=')) + " =`", new Object[0]);
        }
        if (RTGConfig.additionalBiomeInfo() && !(supportedBiomes = (Collection)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> RTGAPI.RTG_BIOMES.containsKey(Biome.func_185362_a((Biome)b))).sorted(Comparator.comparingInt(Biome::func_185362_a)).collect(Collectors.toList())).isEmpty()) {
            String[] supported = new String[]{""};
            supported[0] = supported[0] + System.lineSeparator() + ".= " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '=')) + " = " + String.format("%-24s", new String(new char[24]).replace('\u0000', '=')) + " = " + String.format("%-32s", new String(new char[32]).replace('\u0000', '=')) + " = " + String.format(BIOME_RESLOC_FORMAT, new String(new char[44]).replace('\u0000', '=')) + " = " + String.format("%-24s", new String(new char[24]).replace('\u0000', '=')) + " =.";
            supported[0] = supported[0] + System.lineSeparator() + "|| " + String.format("%-139s", "                                           RTG found realistic versions of the following biomes") + " ||";
            supported[0] = supported[0] + System.lineSeparator() + "|| " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '=')) + " = " + String.format("%-24s", new String(new char[24]).replace('\u0000', '=')) + " = " + String.format("%-32s", new String(new char[32]).replace('\u0000', '=')) + " = " + String.format(BIOME_RESLOC_FORMAT, new String(new char[44]).replace('\u0000', '=')) + " = " + String.format("%-24s", new String(new char[24]).replace('\u0000', '=')) + " ||";
            supported[0] = supported[0] + System.lineSeparator() + "|| " + String.format(ID_FORMAT, "ID") + " | " + String.format("%-24s", "Biome Name") + " | " + String.format("%-32s", "Class Name") + " | " + String.format(BIOME_RESLOC_FORMAT, "Registry Name") + " | " + String.format("%-24s", "Beach Name") + " ||";
            supported[0] = supported[0] + System.lineSeparator() + "|| " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '-')) + " - " + String.format("%-24s", new String(new char[24]).replace('\u0000', '-')) + " - " + String.format("%-32s", new String(new char[32]).replace('\u0000', '-')) + " - " + String.format(BIOME_RESLOC_FORMAT, new String(new char[44]).replace('\u0000', '-')) + " - " + String.format("%-24s", new String(new char[24]).replace('\u0000', '-')) + " ||";
            supportedBiomes.forEach(b -> {
                supported[0] = supported[0] + System.lineSeparator() + "|| " + String.format(ID_FORMAT, Biome.func_185362_a((Biome)b)) + " | " + String.format("%-24s", b.func_185359_l()) + " | " + String.format("%-32s", b.func_150562_l().getSimpleName()) + " | " + String.format(BIOME_RESLOC_FORMAT, b.getRegistryName()) + " | " + String.format("%-24s", RTGAPI.getRTGBiome(b).getBeachBiome().baseBiome().func_185359_l()) + " ||";
            });
            supported[0] = supported[0] + System.lineSeparator() + ".= " + String.format(ID_FORMAT, new String(new char[3]).replace('\u0000', '=')) + " = " + String.format("%-24s", new String(new char[24]).replace('\u0000', '=')) + " = " + String.format("%-32s", new String(new char[32]).replace('\u0000', '=')) + " = " + String.format(BIOME_RESLOC_FORMAT, new String(new char[44]).replace('\u0000', '=')) + " = " + String.format("%-24s", new String(new char[24]).replace('\u0000', '=')) + " =." + System.lineSeparator();
            Logger.info(supported[0], new Object[0]);
        }
    }

    public static void init() {
        Mods.init();
    }

    public static enum Mods {
        abyssalcraft,
        auxbiomes,
        betteragriculture,
        biomesoplenty,
        byg("biomesyougo"),
        bionisation3,
        buildcraftenergy,
        candymod,
        defiledlands,
        douglas_forest,
        environs,
        explorercraft,
        floricraft,
        fyrecraft,
        gravityfalls,
        minecraft,
        mistbiomes,
        nt("novamterram"),
        odioitamod,
        plants2,
        pvj("vibrantjourneys"),
        realworld,
        redwoods,
        rockhounding_surface,
        spookybiomes,
        subaquatic,
        sugiforest,
        terscraft,
        thaumcraft,
        traverse,
        vampirism,
        valoegheses_be("zoesteria");

        private final String prettyName;
        private boolean loaded;

        private Mods() {
            this("");
        }

        private Mods(String name) {
            this.prettyName = !name.isEmpty() ? name : this.name();
        }

        private static void init() {
            Arrays.stream(Mods.values()).forEach(mod -> {
                mod.loaded = Loader.isModLoaded((String)mod.name());
            });
        }

        @Nullable
        public static Mods get(String modId) {
            return Arrays.stream(Mods.values()).filter(mod -> mod.name().equals(modId)).findFirst().orElse(null);
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public ResourceLocation getResourceLocation(String biome) {
            return new ResourceLocation(this.name() + ":" + biome);
        }

        public String getPrettyName() {
            return this.prettyName;
        }
    }
}

