/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.util.BlockUtil;

public class WorldGenLog
extends WorldGenerator {
    private IBlockState logBlock;
    private IBlockState leavesBlock;
    private final int logLength;
    private final boolean generateLeaves;

    public WorldGenLog(IBlockState logBlock, IBlockState leavesBlock, int logLength) {
        this.logBlock = logBlock;
        this.leavesBlock = leavesBlock;
        this.logLength = logLength;
        this.generateLeaves = false;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        IBlockState b;
        int i;
        int z;
        int y;
        int x = pos.func_177958_n();
        IBlockState g = world.func_180495_p(new BlockPos(x, (y = pos.func_177956_o()) - 1, z = pos.func_177952_p()));
        if (g.func_185904_a() != Material.field_151578_c && g.func_185904_a() != Material.field_151577_b && g.func_185904_a() != Material.field_151595_p && g.func_185904_a() != Material.field_151576_e) {
            return false;
        }
        int dir = rand.nextInt(2);
        int air = 0;
        ArrayList<Integer> aX = new ArrayList<Integer>();
        ArrayList<Integer> aY = new ArrayList<Integer>();
        ArrayList<Integer> aZ = new ArrayList<Integer>();
        ArrayList<IBlockState> aBlock = new ArrayList<IBlockState>();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(pos);
        for (i = 0; i < this.logLength && ((b = world.func_180495_p((BlockPos)mpos.func_181079_c(x - (dir == 0 ? 1 : 0), y, z - (dir == 1 ? 1 : 0)))).func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k); ++i) {
            if (this.airCheck(world, x -= dir == 0 ? 1 : 0, y, z -= dir == 1 ? 1 : 0) <= 0) continue;
            return false;
        }
        for (i = 0; i < this.logLength * 2 && ((b = world.func_180495_p((BlockPos)mpos.func_181079_c(x + (dir == 0 ? 1 : 0), y, z + (dir == 1 ? 1 : 0)))).func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k); ++i) {
            if ((air += this.airCheck(world, x, y, z)) > 2) {
                return false;
            }
            if (!BlockUtil.checkVerticalBlocks(BlockUtil.MatchType.ALL, world, pos, 1, Blocks.field_150350_a)) {
                return false;
            }
            aX.add(x);
            aY.add(y);
            aZ.add(z);
            try {
                aBlock.add(this.logBlock.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)(dir == 0 ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z)));
            }
            catch (Exception e) {
                return false;
            }
            if (this.generateLeaves) {
                this.addLeaves(world, rand, dir, x, y, z);
            }
            x += dir == 0 ? 1 : 0;
            z += dir == 1 ? 1 : 0;
        }
        for (i = 0; i < aBlock.size(); ++i) {
            world.func_180501_a((BlockPos)mpos.func_181079_c(((Integer)aX.get(i)).intValue(), ((Integer)aY.get(i)).intValue(), ((Integer)aZ.get(i)).intValue()), (IBlockState)aBlock.get(i), 2);
        }
        return true;
    }

    private int airCheck(World world, int x, int y, int z) {
        IBlockState b = world.func_180495_p(new BlockPos(x, y - 1, z));
        if (b.func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151586_h || b.func_185904_a() == Material.field_151585_k) {
            b = world.func_180495_p(new BlockPos(x, y - 2, z));
            if (b.func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151586_h || b.func_185904_a() == Material.field_151585_k) {
                return 99;
            }
            return 1;
        }
        return 0;
    }

    private void addLeaves(World world, Random rand, int dir, int x, int y, int z) {
        IBlockState b;
        if (dir == 0) {
            b = world.func_180495_p(new BlockPos(x, y, z - 1));
            if ((b.func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_180501_a(new BlockPos(x, y, z - 1), this.leavesBlock, 2);
            }
            if (((b = world.func_180495_p(new BlockPos(x, y, z + 1))).func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_180501_a(new BlockPos(x, y, z + 1), this.leavesBlock, 2);
            }
        } else {
            b = world.func_180495_p(new BlockPos(x - 1, y, z));
            if ((b.func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_180501_a(new BlockPos(x - 1, y, z), this.leavesBlock, 2);
            }
            if (((b = world.func_180495_p(new BlockPos(x + 1, y, z))).func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k) && rand.nextInt(3) == 0) {
                world.func_180501_a(new BlockPos(x + 1, y, z), this.leavesBlock, 2);
            }
        }
        if (((b = world.func_180495_p(new BlockPos(x, y + 1, z))).func_185904_a() == Material.field_151579_a || b.func_185904_a() == Material.field_151582_l || b.func_185904_a() == Material.field_151585_k) && rand.nextInt(3) == 0) {
            world.func_180501_a(new BlockPos(x, y + 1, z), this.leavesBlock, 2);
        }
    }

    public IBlockState getLogBlock() {
        return this.logBlock;
    }

    public WorldGenLog setLogBlock(IBlockState logBlock) {
        this.logBlock = logBlock;
        return this;
    }

    public IBlockState getLeavesBlock() {
        return this.leavesBlock;
    }

    public WorldGenLog setLeavesBlock(IBlockState leavesBlock) {
        this.leavesBlock = leavesBlock;
        return this;
    }
}

