/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.util.BlockUtil;
import rtg.api.util.Logger;

public class WorldGenFlowersRTG
extends WorldGenerator {
    private final Collection<BlockFlower.EnumFlowerType> flowers;

    public WorldGenFlowersRTG(Collection<BlockFlower.EnumFlowerType> flowers) {
        this.flowers = Collections.unmodifiableCollection(flowers);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.flowers == null || this.flowers.isEmpty()) {
            Logger.error("Tried to generate a flower from an null or empty collection in Dim: {}, at coords {}", world.field_73011_w.getDimension(), pos);
            return false;
        }
        IBlockState flower = BlockUtil.getStateFlower((BlockFlower.EnumFlowerType)Iterables.get(this.flowers, (int)new Random().nextInt(this.flowers.size())));
        BlockFlower block = (BlockFlower)flower.func_177230_c();
        if (world.func_175623_d(pos) && pos.func_177956_o() < 255 && block.func_176196_c(world, pos) && block.func_180671_f(world, pos, flower)) {
            world.func_180501_a(pos, flower, 2);
            return true;
        }
        return false;
    }
}

