/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco.collection;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import rtg.api.config.BiomeConfig;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.collection.DecoCollectionBase;
import rtg.api.world.deco.helper.DecoHelper5050;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPiceaPungens;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPiceaSitchensis;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPinusPonderosa;

public class DecoCollectionIceTrees
extends DecoCollectionBase {
    private final DecoTree.Distribution forestDistribution = new DecoTree.Distribution(100.0f, 6.0f, 0.8f);
    private final float short1Min = -3.0f;
    private final float short1Max = -1.0f;
    private final float tallMin = -1.0f;
    private final float tallMax = 3.0f;
    private final float short2Min = 3.0f;
    private final float short2Max = 5.0f;

    public DecoCollectionIceTrees(BiomeConfig config) {
        super(config);
        this.addDeco(this.tallTrees(-1.0f, 3.0f)).addDeco(this.shortTrees(-3.0f, -1.0f)).addDeco(this.shortTrees(3.0f, 5.0f)).addDeco(this.randomPungensTrees()).addDeco(this.shrubsIce());
    }

    private DecoHelper5050 tallTrees(float noiseMin, float noiseMax) {
        return new DecoHelper5050(this.tallPineTrees(Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), noiseMin, noiseMax), this.tallPineTrees(Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), noiseMin, noiseMax));
    }

    private DecoTree tallPineTrees(IBlockState log, IBlockState leaves, float noiseMin, float noiseMax) {
        TreeRTGPinusPonderosa pinusPonderosa = new TreeRTGPinusPonderosa();
        pinusPonderosa.setLogBlock(log);
        pinusPonderosa.setLeavesBlock(leaves);
        pinusPonderosa.setMinTrunkSize(8);
        pinusPonderosa.setMaxTrunkSize(21);
        pinusPonderosa.setMinCrownSize(13);
        pinusPonderosa.setMaxCrownSize(29);
        ArrayList<IBlockState> validBlocks = pinusPonderosa.getValidGroundBlocks();
        validBlocks.add(Blocks.field_150433_aE.func_176223_P());
        pinusPonderosa.setValidGroundBlocks(validBlocks);
        this.addTree(pinusPonderosa);
        return new DecoTree(pinusPonderosa).setStrengthFactorForLoops(4.0f).setTreeType(DecoTree.TreeType.RTG_TREE).setDistribution(this.forestDistribution).setTreeCondition(DecoTree.TreeCondition.NOISE_BETWEEN_AND_RANDOM_CHANCE).setTreeConditionNoise(noiseMin).setTreeConditionNoise2(noiseMax).setTreeConditionChance(2).setMaxY(85);
    }

    private DecoHelper5050 shortTrees(float noiseMin, float noiseMax) {
        return new DecoHelper5050(this.shortPineTrees(Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), noiseMin, noiseMax), this.shortPineTrees(Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), noiseMin, noiseMax));
    }

    private DecoTree shortPineTrees(IBlockState log, IBlockState leaves, float noiseMin, float noiseMax) {
        TreeRTG piceaSitchensis = new TreeRTGPiceaSitchensis().setLogBlock(log).setLeavesBlock(leaves).setMinTrunkSize(4).setMaxTrunkSize(8).setMinCrownSize(4).setMaxCrownSize(14);
        ArrayList<IBlockState> validBlocks = piceaSitchensis.getValidGroundBlocks();
        validBlocks.add(Blocks.field_150433_aE.func_176223_P());
        piceaSitchensis.setValidGroundBlocks(validBlocks);
        this.addTree(piceaSitchensis);
        return new DecoTree(piceaSitchensis).setStrengthFactorForLoops(4.0f).setTreeType(DecoTree.TreeType.RTG_TREE).setDistribution(this.forestDistribution).setTreeCondition(DecoTree.TreeCondition.NOISE_BETWEEN_AND_RANDOM_CHANCE).setTreeConditionNoise(noiseMin).setTreeConditionNoise2(noiseMax).setTreeConditionChance(2).setMaxY(85);
    }

    private DecoTree randomPungensTrees() {
        TreeRTG piceaPungens = new TreeRTGPiceaPungens().setLogBlock(Blocks.field_150403_cj.func_176223_P()).setLeavesBlock(Blocks.field_150432_aD.func_176223_P()).setMinTrunkSize(2).setMaxTrunkSize(4).setMinCrownSize(4).setMaxCrownSize(8);
        ArrayList<IBlockState> validBlocks = piceaPungens.getValidGroundBlocks();
        validBlocks.add(Blocks.field_150433_aE.func_176223_P());
        piceaPungens.setValidGroundBlocks(validBlocks);
        this.addTree(piceaPungens);
        return new DecoTree(piceaPungens).setStrengthFactorForLoops(3.0f).setTreeType(DecoTree.TreeType.RTG_TREE).setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE).setTreeConditionChance(8).setMaxY(100);
    }

    private DecoShrub shrubsIce() {
        return new DecoShrub().setLogBlock(Blocks.field_150403_cj.func_176223_P()).setLeavesBlock(Blocks.field_150432_aD.func_176223_P()).setMaxY(140).setLoopMultiplier(4.0f).setChance(3);
    }
}

