/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco.collection;

import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoFlowersRTG;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.collection.DecoCollectionBase;
import rtg.api.world.deco.helper.DecoHelperRandomSplit;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGBetulaPapyrifera;

public class DecoCollectionBirchForest
extends DecoCollectionBase {
    public DecoCollectionBirchForest(BiomeConfig config) {
        super(config);
        this.addDeco(this.tallBirchTrees()).addDeco(this.randomTrees()).addDeco(this.logs(), config.ALLOW_LOGS.get()).addDeco(this.shrubsOak()).addDeco(this.flowers());
    }

    private DecoHelperRandomSplit randomTrees() {
        return new DecoHelperRandomSplit().setDecos(new DecoBase[]{this.tallBirchTrees(), this.vanillaTrees()}).setChances(new int[]{10, 4});
    }

    private DecoTree tallBirchTrees() {
        TreeRTG birchTree = new TreeRTGBetulaPapyrifera().setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH)).setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.BIRCH)).setMinTrunkSize(4).setMaxTrunkSize(10).setMinCrownSize(8).setMaxCrownSize(19);
        this.addTree(birchTree);
        return new DecoTree(birchTree).setStrengthFactorForLoops(3.0f).setTreeType(DecoTree.TreeType.RTG_TREE).setTreeCondition(DecoTree.TreeCondition.ALWAYS_GENERATE).setMaxY(100);
    }

    private DecoTree vanillaTrees() {
        return new DecoTree((WorldGenerator)new WorldGenTrees(false)).setTreeType(DecoTree.TreeType.WORLDGEN).setStrengthFactorForLoops(3.0f).setTreeCondition(DecoTree.TreeCondition.ALWAYS_GENERATE).setMaxY(100);
    }

    private DecoFallenTree logs() {
        return new DecoFallenTree().setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE).setLogConditionChance(8).setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH)).setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.BIRCH)).setMinSize(3).setMaxSize(6);
    }

    private DecoShrub shrubsOak() {
        return new DecoShrub().setMaxY(120).setLoopMultiplier(3.0f);
    }

    private DecoFlowersRTG flowers() {
        return new DecoFlowersRTG().addFlowers(BlockFlower.EnumFlowerType.HOUSTONIA, BlockFlower.EnumFlowerType.WHITE_TULIP).setMaxY(128).setStrengthFactor(12.0f);
    }
}

