/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import rtg.RTGConfig;
import rtg.api.event.DecorateBiomeEventRTG;
import rtg.api.util.BlockUtil;
import rtg.api.util.Logger;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;

public class DecoTree
extends DecoBase {
    public static final double MAX_TREE_DENSITY = 5.0;
    protected int loops;
    protected float strengthFactorForLoops;
    protected boolean strengthNoiseFactorForLoops;
    protected boolean strengthNoiseFactorXForLoops;
    protected TreeType treeType;
    protected TreeRTG tree;
    protected WorldGenerator worldGen;
    protected Distribution distribution;
    protected TreeCondition treeCondition;
    protected float treeConditionNoise;
    protected float treeConditionNoise2;
    protected int treeConditionChance;
    protected float treeConditionFloat;
    protected int minY;
    protected int maxY;
    protected IBlockState logBlock;
    protected IBlockState leavesBlock;
    protected int minSize;
    protected int maxSize;
    protected int minTrunkSize;
    protected int maxTrunkSize;
    protected int minCrownSize;
    protected int maxCrownSize;
    protected boolean noLeaves;

    public DecoTree() {
        this.setLoops(1);
        this.setStrengthFactorForLoops(0.0f);
        this.setStrengthNoiseFactorForLoops(false);
        this.setStrengthNoiseFactorXForLoops(false);
        this.setTreeType(TreeType.RTG_TREE);
        this.tree = null;
        this.worldGen = null;
        this.setDistribution(new Distribution(100.0f, 5.0f, 0.8f));
        this.setTreeCondition(TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE);
        this.setTreeConditionNoise(0.0f);
        this.setTreeConditionNoise2(0.0f);
        this.setTreeConditionFloat(0.0f);
        this.setTreeConditionChance(1);
        this.setMinY(63);
        this.setMaxY(230);
        this.setLogBlock(Blocks.field_150364_r.func_176223_P());
        this.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        this.setMinSize(2);
        this.setMaxSize(4);
        this.setMinTrunkSize(2);
        this.setMaxTrunkSize(4);
        this.setMinCrownSize(2);
        this.setMaxCrownSize(4);
        this.setNoLeaves(false);
        this.addDecoTypes(DecoBase.DecoType.TREE);
    }

    public DecoTree(DecoTree source) {
        this();
        this.setLoops(source.loops);
        this.setStrengthFactorForLoops(source.strengthFactorForLoops);
        this.setStrengthNoiseFactorForLoops(source.strengthNoiseFactorForLoops);
        this.setStrengthNoiseFactorXForLoops(source.strengthNoiseFactorXForLoops);
        this.setTreeType(source.treeType);
        this.tree = source.tree;
        this.worldGen = source.worldGen;
        this.setDistribution(source.distribution);
        this.setTreeCondition(source.treeCondition);
        this.setTreeConditionNoise(source.treeConditionNoise);
        this.setTreeConditionNoise2(source.treeConditionNoise2);
        this.setTreeConditionFloat(source.treeConditionFloat);
        this.setTreeConditionChance(source.treeConditionChance);
        this.setMinY(source.minY);
        this.setMaxY(source.maxY);
        this.setLogBlock(source.logBlock);
        this.setLeavesBlock(source.leavesBlock);
        this.setMinSize(source.minSize);
        this.setMaxSize(source.maxSize);
        this.setMinTrunkSize(source.minTrunkSize);
        this.setMaxTrunkSize(source.maxTrunkSize);
        this.setMinCrownSize(source.minCrownSize);
        this.setMaxCrownSize(source.maxCrownSize);
        this.setNoLeaves(source.noLeaves);
    }

    public DecoTree(TreeRTG tree) {
        this();
        this.tree = tree;
        this.setLogBlock(tree.getLogBlock());
        this.setLeavesBlock(tree.getLeavesBlock());
        this.setMinTrunkSize(tree.getMinTrunkSize());
        this.setMaxTrunkSize(tree.getMaxTrunkSize());
        this.setMinCrownSize(tree.getMinCrownSize());
        this.setMaxCrownSize(tree.getMaxCrownSize());
        this.setNoLeaves(tree.getNoLeaves());
    }

    public DecoTree(WorldGenerator worldGen) {
        this();
        this.worldGen = worldGen;
    }

    @Override
    @Deprecated
    public boolean properlyDefined() {
        if (this.treeType == TreeType.RTG_TREE && this.tree == null) {
            return false;
        }
        return super.properlyDefined();
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        BlockPos offsetPos = DecoTree.getOffsetPos(chunkPos);
        float noise = rtgWorld.simplexInstance(0).noise2f((float)offsetPos.func_177958_n() / this.distribution.getNoiseDivisor(), (float)offsetPos.func_177952_p() / this.distribution.getNoiseDivisor()) * this.distribution.getNoiseFactor() + this.distribution.getNoiseAddend();
        int loopCount = this.strengthFactorForLoops > 0.0f ? (int)this.strengthFactorForLoops : this.loops;
        loopCount = this.strengthNoiseFactorForLoops ? (int)noise : loopCount;
        int n = loopCount = this.strengthNoiseFactorXForLoops ? (int)(noise * this.strengthFactorForLoops) : loopCount;
        if (loopCount < 1) {
            return;
        }
        if ((loopCount = this.applyConfigMultipliers(loopCount, biome)) < 1) {
            return;
        }
        DecorateBiomeEventRTG.DecorateRTG event = new DecorateBiomeEventRTG.DecorateRTG(rtgWorld.world(), rand, offsetPos, DecorateBiomeEvent.Decorate.EventType.TREE, loopCount);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DENY) {
            loopCount = event.getModifiedAmount();
            if (loopCount < 1) {
                return;
            }
            DecoBase.tweakTreeLeaves(this, false, true);
            block4: for (int i = 0; i < loopCount; ++i) {
                BlockPos pos = offsetPos.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
                int y = rtgWorld.world().func_175645_m(pos).func_177956_o();
                if (y > this.maxY || y < this.minY || !this.isValidTreeCondition(noise, rand)) continue;
                if (hasVillage && (BlockUtil.checkVerticalBlocks(BlockUtil.MatchType.ALL, rtgWorld.world(), pos, -1, Blocks.field_150458_ak) || !BlockUtil.checkAreaBlocks(BlockUtil.MatchType.ALL_IGNORE_REPLACEABLE, rtgWorld.world(), pos, 2, new Block[0]))) {
                    return;
                }
                switch (this.treeType) {
                    case RTG_TREE: {
                        this.tree.setLogBlock(this.logBlock);
                        this.tree.setLeavesBlock(this.leavesBlock);
                        this.tree.setTrunkSize(DecoTree.getRangedRandom(rand, this.minTrunkSize, this.maxTrunkSize));
                        this.tree.setCrownSize(DecoTree.getRangedRandom(rand, this.minCrownSize, this.maxCrownSize));
                        this.tree.setNoLeaves(this.noLeaves);
                        this.tree.func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
                        continue block4;
                    }
                    case WORLDGEN: {
                        WorldGenerator worldgenerator = this.worldGen;
                        worldgenerator.func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
                        continue block4;
                    }
                }
            }
        } else if (RTGConfig.enableDebugging()) {
            Logger.debug("Tree generation was cancelled @ ChunkPos{}", chunkPos);
        }
    }

    public boolean isValidTreeCondition(float noise, Random rand) {
        switch (this.treeCondition) {
            case ALWAYS_GENERATE: {
                return true;
            }
            case NOISE_GREATER_AND_RANDOM_CHANCE: {
                return noise > this.treeConditionNoise && rand.nextInt(this.treeConditionChance) == 0;
            }
            case NOISE_LESSER_AND_RANDOM_CHANCE: {
                return noise < this.treeConditionNoise && rand.nextInt(this.treeConditionChance) == 0;
            }
            case NOISE_BETWEEN_AND_RANDOM_CHANCE: {
                boolean noiseGreaterThanMin = noise >= this.treeConditionNoise;
                boolean noiseLessThanMax = -noise <= this.treeConditionNoise2;
                boolean randomResult = rand.nextInt(this.treeConditionChance) == 0;
                return noiseGreaterThanMin && noiseLessThanMax && randomResult;
            }
            case RANDOM_CHANCE: {
                return rand.nextInt(this.treeConditionChance) == 0;
            }
            case RANDOM_NOT_EQUALS_CHANCE: {
                return rand.nextInt(this.treeConditionChance) != 0;
            }
        }
        return false;
    }

    public int getLoops() {
        return this.loops;
    }

    public DecoTree setLoops(int loops) {
        this.loops = loops;
        return this;
    }

    public float getStrengthFactorForLoops() {
        return this.strengthFactorForLoops;
    }

    public DecoTree setStrengthFactorForLoops(float strengthFactorForLoops) {
        this.strengthFactorForLoops = strengthFactorForLoops;
        return this;
    }

    public boolean isStrengthNoiseFactorForLoops() {
        return this.strengthNoiseFactorForLoops;
    }

    public DecoTree setStrengthNoiseFactorForLoops(boolean strengthNoiseFactorForLoops) {
        this.strengthNoiseFactorForLoops = strengthNoiseFactorForLoops;
        return this;
    }

    public boolean isStrengthNoiseFactorXForLoops() {
        return this.strengthNoiseFactorXForLoops;
    }

    public DecoTree setStrengthNoiseFactorXForLoops(boolean strengthNoiseFactorXForLoops) {
        this.strengthNoiseFactorXForLoops = strengthNoiseFactorXForLoops;
        return this;
    }

    public TreeType getTreeType() {
        return this.treeType;
    }

    public DecoTree setTreeType(TreeType treeType) {
        this.treeType = treeType;
        return this;
    }

    public TreeRTG getTree() {
        return this.tree;
    }

    public DecoTree setTree(TreeRTG tree) {
        this.tree = tree;
        return this;
    }

    public WorldGenerator getWorldGen() {
        return this.worldGen;
    }

    public DecoTree setWorldGen(WorldGenerator worldGen) {
        this.worldGen = worldGen;
        return this;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public DecoTree setDistribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public TreeCondition getTreeCondition() {
        return this.treeCondition;
    }

    public DecoTree setTreeCondition(TreeCondition treeCondition) {
        this.treeCondition = treeCondition;
        return this;
    }

    public float getTreeConditionNoise() {
        return this.treeConditionNoise;
    }

    public DecoTree setTreeConditionNoise(float treeConditionNoise) {
        this.treeConditionNoise = treeConditionNoise;
        return this;
    }

    public float getTreeConditionNoise2() {
        return this.treeConditionNoise2;
    }

    public DecoTree setTreeConditionNoise2(float treeConditionNoise2) {
        this.treeConditionNoise2 = treeConditionNoise2;
        return this;
    }

    public int getTreeConditionChance() {
        return this.treeConditionChance;
    }

    public DecoTree setTreeConditionChance(int treeConditionChance) {
        this.treeConditionChance = treeConditionChance;
        return this;
    }

    public float getTreeConditionFloat() {
        return this.treeConditionFloat;
    }

    public DecoTree setTreeConditionFloat(float treeConditionFloat) {
        this.treeConditionFloat = treeConditionFloat;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public DecoTree setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoTree setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public IBlockState getLogBlock() {
        return this.logBlock;
    }

    public DecoTree setLogBlock(IBlockState logBlock) {
        this.logBlock = logBlock;
        return this;
    }

    public IBlockState getLeavesBlock() {
        return this.leavesBlock;
    }

    public DecoTree setLeavesBlock(IBlockState leavesBlock) {
        this.leavesBlock = leavesBlock;
        return this;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public DecoTree setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public DecoTree setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMinTrunkSize() {
        return this.minTrunkSize;
    }

    public DecoTree setMinTrunkSize(int minTrunkSize) {
        this.minTrunkSize = minTrunkSize;
        return this;
    }

    public int getMaxTrunkSize() {
        return this.maxTrunkSize;
    }

    public DecoTree setMaxTrunkSize(int maxTrunkSize) {
        this.maxTrunkSize = maxTrunkSize;
        return this;
    }

    public int getMinCrownSize() {
        return this.minCrownSize;
    }

    public DecoTree setMinCrownSize(int minCrownSize) {
        this.minCrownSize = minCrownSize;
        return this;
    }

    public int getMaxCrownSize() {
        return this.maxCrownSize;
    }

    public DecoTree setMaxCrownSize(int maxCrownSize) {
        this.maxCrownSize = maxCrownSize;
        return this;
    }

    public boolean isNoLeaves() {
        return this.noLeaves;
    }

    public DecoTree setNoLeaves(boolean noLeaves) {
        this.noLeaves = noLeaves;
        return this;
    }

    private int applyConfigMultipliers(int loopCount, IRealisticBiome biome) {
        return (int)((double)loopCount * Math.min(RTGConfig.treeDensityMultiplier() * (double)biome.getConfig().TREE_DENSITY_MULTIPLIER.get(), 5.0));
    }

    @Deprecated
    public static class Distribution {
        protected float noiseDivisor;
        protected float noiseFactor;
        protected float noiseAddend;

        public Distribution(float noiseDivisor, float noiseFactor, float noiseAddend) {
            this.noiseDivisor = noiseDivisor;
            this.noiseFactor = noiseFactor;
            this.noiseAddend = noiseAddend;
        }

        public float getNoiseDivisor() {
            return this.noiseDivisor;
        }

        public Distribution setNoiseDivisor(float noiseDivisor) {
            this.noiseDivisor = noiseDivisor;
            return this;
        }

        public float getNoiseFactor() {
            return this.noiseFactor;
        }

        public Distribution setNoiseFactor(float noiseFactor) {
            this.noiseFactor = noiseFactor;
            return this;
        }

        public float getNoiseAddend() {
            return this.noiseAddend;
        }

        public Distribution setNoiseAddend(float noiseAddend) {
            this.noiseAddend = noiseAddend;
            return this;
        }
    }

    public static enum TreeCondition {
        ALWAYS_GENERATE,
        NOISE_GREATER_AND_RANDOM_CHANCE,
        NOISE_LESSER_AND_RANDOM_CHANCE,
        NOISE_BETWEEN_AND_RANDOM_CHANCE,
        RANDOM_CHANCE,
        RANDOM_NOT_EQUALS_CHANCE;

    }

    public static enum TreeType {
        RTG_TREE,
        WORLDGEN;

    }
}

