/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.util.Logger;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.WorldGenDoublePlantRTG;
import rtg.api.world.gen.feature.WorldGenFlowersRTG;

public class DecoFlowersRTG
extends DecoBase {
    private final Collection<BlockFlower.EnumFlowerType> flowers = Sets.newHashSet();
    private final Collection<BlockDoublePlant.EnumPlantType> plants = Sets.newHashSet();
    private float strengthFactor;
    private int minY;
    private int maxY;
    @Deprecated
    private HeightType heightType;
    private int chance;
    private int notEqualsZeroChance;
    private int loops;

    public DecoFlowersRTG() {
        this.setChance(1);
        this.setNotEqualsZeroChance(1);
        this.setMinY(1);
        this.setMaxY(255);
        this.setHeightType(HeightType.NEXT_INT);
        this.setStrengthFactor(0.0f);
        this.setLoops(1);
        this.addDecoTypes(DecoBase.DecoType.FLOWER);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        if ((this.flowers == null || this.flowers.isEmpty()) && (this.plants == null || this.plants.isEmpty())) {
            Logger.error("DecoFlowersRTG called with a null or empty flower/plant list in biome {} at chunk {}", Biome.field_185377_q.func_177774_c((Object)biome.baseBiome()), chunkPos.toString());
            return;
        }
        if (TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            int loopCount = this.strengthFactor > 0.0f ? (int)this.strengthFactor : this.loops;
            for (int i = 0; i < loopCount * 16; ++i) {
                int y;
                BlockPos pos = DecoFlowersRTG.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
                switch (this.heightType) {
                    case NEXT_INT: {
                        y = DecoFlowersRTG.getRangedRandom(rand, this.minY, this.maxY);
                        break;
                    }
                    case GET_HEIGHT_VALUE: {
                        y = rtgWorld.world().func_175645_m(pos).func_177956_o();
                        break;
                    }
                    default: {
                        y = rand.nextInt(this.maxY);
                    }
                }
                if (this.flowers != null && !this.flowers.isEmpty()) {
                    if (this.notEqualsZeroChance > 1) {
                        if (rand.nextInt(this.notEqualsZeroChance) != 0) {
                            new WorldGenFlowersRTG(this.flowers).func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
                        }
                    } else if (rand.nextInt(this.chance) == 0) {
                        new WorldGenFlowersRTG(this.flowers).func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
                    }
                }
                if (this.plants == null || this.plants.isEmpty()) continue;
                if (this.notEqualsZeroChance > 1) {
                    if (rand.nextInt(this.notEqualsZeroChance) == 0) continue;
                    new WorldGenDoublePlantRTG((BlockDoublePlant.EnumPlantType)Iterables.get(this.plants, (int)rand.nextInt(this.plants.size()))).func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
                    continue;
                }
                if (rand.nextInt(this.chance) != 0) continue;
                new WorldGenDoublePlantRTG((BlockDoublePlant.EnumPlantType)Iterables.get(this.plants, (int)rand.nextInt(this.plants.size()))).func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
            }
        }
    }

    public DecoFlowersRTG addFlowers(BlockFlower.EnumFlowerType ... flowers) {
        this.flowers.addAll(Lists.newArrayList((Object[])flowers));
        return this;
    }

    public DecoFlowersRTG addPlants(BlockDoublePlant.EnumPlantType ... plants) {
        this.plants.addAll(Lists.newArrayList((Object[])plants));
        return this;
    }

    public Collection<BlockFlower.EnumFlowerType> getFlowers() {
        return Collections.unmodifiableCollection(this.flowers);
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoFlowersRTG setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public DecoFlowersRTG setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoFlowersRTG setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public HeightType getHeightType() {
        return this.heightType;
    }

    public DecoFlowersRTG setHeightType(HeightType heightType) {
        this.heightType = heightType;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public DecoFlowersRTG setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getNotEqualsZeroChance() {
        return this.notEqualsZeroChance;
    }

    public DecoFlowersRTG setNotEqualsZeroChance(int notEqualsZeroChance) {
        this.notEqualsZeroChance = notEqualsZeroChance;
        return this;
    }

    public int getLoops() {
        return this.loops;
    }

    public DecoFlowersRTG setLoops(int loops) {
        this.loops = loops;
        return this;
    }

    @Deprecated
    public static enum HeightType {
        NEXT_INT,
        GET_HEIGHT_VALUE;

    }
}

