/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.biome;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeDictionary;
import rtg.RTG;
import rtg.RTGConfig;
import rtg.api.RTGAPI;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.VoronoiResult;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.surface.SurfaceRiverOasis;
import rtg.api.world.terrain.TerrainBase;
import rtg.compat.ModCompat;

public abstract class RealisticBiomeBase
implements IRealisticBiome {
    private final Biome baseBiome;
    private final ResourceLocation baseBiomeResLoc;
    private final int baseBiomeId;
    private final RiverType riverType;
    private final BeachType beachType;
    private final BiomeConfig config;
    private final TerrainBase terrain;
    private final SurfaceBase surface;
    private final SurfaceBase surfaceRiver;
    private final Collection<DecoBase> decos;
    @Deprecated
    private final Collection<TreeRTG> rtgTrees;

    public RealisticBiomeBase(@Nonnull Biome baseBiome) {
        this(baseBiome, RiverType.NORMAL, BeachType.NORMAL);
    }

    public RealisticBiomeBase(@Nonnull Biome baseBiome, @Nonnull RiverType riverType) {
        this(baseBiome, riverType, BeachType.NORMAL);
    }

    public RealisticBiomeBase(@Nonnull Biome baseBiome, @Nonnull BeachType beachType) {
        this(baseBiome, RiverType.NORMAL, beachType);
    }

    public RealisticBiomeBase(@Nonnull Biome baseBiome, @Nonnull RiverType riverType, @Nonnull BeachType beachType) {
        ResourceLocation resloc = baseBiome.getRegistryName();
        if (resloc == null) {
            throw new IllegalStateException(String.format("Biome with ID: %s, of class: %s, does not have a registry name set.", Biome.func_185362_a((Biome)baseBiome), baseBiome.getClass().getName()));
        }
        this.baseBiome = baseBiome;
        this.baseBiomeResLoc = resloc;
        this.baseBiomeId = Biome.func_185362_a((Biome)baseBiome);
        this.riverType = riverType;
        this.beachType = beachType;
        this.config = new BiomeConfig(this.getConfigFile());
        this.initConfig();
        this.getConfig().loadConfig();
        this.terrain = this.initTerrain();
        this.surface = this.initSurface();
        this.surfaceRiver = new SurfaceRiverOasis(this.config);
        this.decos = new ArrayList<DecoBase>();
        this.rtgTrees = new ArrayList<TreeRTG>();
        this.initDecos();
        this.overrideDecorations();
    }

    @Override
    public BiomeConfig getConfig() {
        return this.config;
    }

    @Override
    public final Biome baseBiome() {
        return this.baseBiome;
    }

    @Override
    public RiverType getRiverType() {
        return this.riverType;
    }

    @Override
    public BeachType getBeachType() {
        return this.beachType;
    }

    @Override
    public Biome preferredBeach() {
        return this.beachType.getBiome();
    }

    @Override
    public IRealisticBiome getRiverBiome() {
        return this.riverType.getRTGBiome();
    }

    @Override
    public IRealisticBiome getBeachBiome() {
        IRealisticBiome rbb = RTGAPI.getRTGBiome(Biome.func_185362_a((Biome)this.preferredBeach()));
        int configBiomeId = this.getConfig().BEACH_BIOME.get();
        if (configBiomeId > -1) {
            rbb = RTGAPI.getRTGBiome(configBiomeId);
        }
        return rbb;
    }

    @Override
    public void overrideDecorations() {
    }

    @Override
    public Collection<DecoBase> getDecos() {
        return this.decos;
    }

    @Override
    public Collection<TreeRTG> getTrees() {
        return this.rtgTrees;
    }

    @Override
    public ResourceLocation baseBiomeResLoc() {
        return this.baseBiomeResLoc;
    }

    @Override
    public int baseBiomeId() {
        return this.baseBiomeId;
    }

    @Override
    public float rNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
        if (!this.getConfig().ALLOW_RIVERS.get()) {
            float borderForRiver = border * 2.0f;
            if (borderForRiver > 1.0f) {
                borderForRiver = 1.0f;
            }
            river = 1.0f - (1.0f - borderForRiver) * (1.0f - river);
            return this.terrain.generateNoise(rtgWorld, x, y, border, river);
        }
        float lakeStrength = this.lakePressure(rtgWorld, x, y, border, rtgWorld.getLakeFrequency(), rtgWorld.getLakeBendSizeLarge(), rtgWorld.getLakeBendSizeMedium(), rtgWorld.getLakeBendSizeSmall());
        float lakeFlattening = this.lakeFlattening(lakeStrength, rtgWorld.getLakeShoreLevel(), rtgWorld.getLakeDepressionLevel());
        if (river < 1.0f && lakeFlattening < 1.0f) {
            river = (1.0f - river) / river + (1.0f - lakeFlattening) / lakeFlattening;
            river = 1.0f / (river + 1.0f);
        } else if (lakeFlattening < river) {
            river = lakeFlattening;
        }
        river = 1.0f - river;
        river *= river / (river + 0.05f) * 1.05f;
        river = 1.0f - river;
        float riverFlattening = river * 1.1034483f - 0.10344828f;
        if (riverFlattening < 0.0f) {
            riverFlattening = 0.0f;
        }
        float terrainNoise = this.terrain.generateNoise(rtgWorld, x, y, border, riverFlattening);
        return this.erodedNoise(rtgWorld, x, y, river, border, terrainNoise);
    }

    public float erodedNoise(RTGWorld rtgWorld, int x, int y, float river, float border, float biomeHeight) {
        float riverFlattening = 1.0f - river;
        if ((riverFlattening -= 0.90625f) < 0.0f) {
            return biomeHeight;
        }
        float r = 1.0f - (riverFlattening /= 0.09375f);
        if (r < 1.0f && biomeHeight > 55.0f) {
            float irregularity = rtgWorld.simplexInstance(0).noise2f((float)x / 12.0f, (float)y / 12.0f) * 2.0f + rtgWorld.simplexInstance(0).noise2f((float)x / 8.0f, (float)y / 8.0f);
            return biomeHeight * r + (55.0f + (irregularity *= 1.0f + r)) * (1.0f - r);
        }
        return biomeHeight;
    }

    @Override
    public float lakePressure(RTGWorld rtgWorld, int x, int y, float border, float lakeInterval, float largeBendSize, float mediumBendSize, float smallBendSize) {
        if (!this.getConfig().ALLOW_SCENIC_LAKES.get()) {
            return 1.0f;
        }
        double pX = x;
        double pY = y;
        ISimplexData2D jitterData = SimplexData2D.newDisk();
        rtgWorld.simplexInstance(1).multiEval2D((double)x / 240.0, (double)y / 240.0, jitterData);
        pX += jitterData.getDeltaX() * (double)largeBendSize;
        pY += jitterData.getDeltaY() * (double)largeBendSize;
        rtgWorld.simplexInstance(0).multiEval2D((double)x / 80.0, (double)y / 80.0, jitterData);
        pX += jitterData.getDeltaX() * (double)mediumBendSize;
        pY += jitterData.getDeltaY() * (double)mediumBendSize;
        rtgWorld.simplexInstance(4).multiEval2D((double)x / 30.0, (double)y / 30.0, jitterData);
        VoronoiResult lakeResults = rtgWorld.cellularInstance(0).eval2D((pX += jitterData.getDeltaX() * (double)smallBendSize) / (double)lakeInterval, (pY += jitterData.getDeltaY() * (double)smallBendSize) / (double)lakeInterval);
        return (float)(1.0 - lakeResults.interiorValue());
    }

    public float lakeFlattening(float pressure, float shoreLevel, float topLevel) {
        if (pressure > topLevel) {
            return 1.0f;
        }
        if (pressure < shoreLevel) {
            return pressure / shoreLevel * 0.09375f;
        }
        float proportion = (pressure - shoreLevel) / (topLevel - shoreLevel);
        return 0.09375f + proportion * 0.90625f;
    }

    @Override
    public void rReplace(ChunkPrimer primer, BlockPos blockPos, int x, int y, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        this.rReplace(primer, blockPos.func_177958_n(), blockPos.func_177952_p(), x, y, depth, rtgWorld, noise, river, base);
    }

    @Override
    public void rReplace(ChunkPrimer primer, int i, int j, int x, int y, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        if (RTG.surfacesDisabled() || this.getConfig().DISABLE_RTG_SURFACES.get()) {
            return;
        }
        float riverRegion = !this.getConfig().ALLOW_RIVERS.get() ? 0.0f : river;
        this.surface.paintTerrain(primer, i, j, x, y, depth, rtgWorld, noise, riverRegion, base);
    }

    protected void rReplaceWithRiver(ChunkPrimer primer, int i, int j, int x, int y, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        if (RTG.surfacesDisabled() || this.getConfig().DISABLE_RTG_SURFACES.get()) {
            return;
        }
        float riverRegion = !this.getConfig().ALLOW_RIVERS.get() ? 0.0f : river;
        this.surface.paintTerrain(primer, i, j, x, y, depth, rtgWorld, noise, riverRegion, base);
        if (RTGConfig.lushRiverbanksInDesert()) {
            this.surfaceRiver.paintTerrain(primer, i, j, x, y, depth, rtgWorld, noise, riverRegion, base);
        }
    }

    @Override
    public TerrainBase terrain() {
        return this.terrain;
    }

    @Override
    public SurfaceBase surface() {
        return this.surface;
    }

    @Override
    public double waterLakeMult() {
        return this.getConfig().SURFACE_WATER_LAKE_MULT.get();
    }

    @Override
    public double lavaLakeMult() {
        return this.getConfig().SURFACE_LAVA_LAKE_MULT.get();
    }

    private File getConfigFile() {
        ModCompat.Mods mod = Objects.requireNonNull(ModCompat.Mods.get(this.baseBiomeResLoc().func_110624_b()), "ModCompat.Mods does not have a value for the mod that added this biome.");
        return RTGAPI.getBiomeConfigPath().resolve(mod.getPrettyName()).resolve(this.baseBiomeResLoc().func_110623_a() + ".cfg").toFile();
    }

    protected BeachType determineBeachType() {
        if (this.baseBiome().func_185353_n() <= 0.05f || BiomeDictionary.hasType((Biome)this.baseBiome(), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return BeachType.COLD;
        }
        float height = this.baseBiome().func_185355_j() + this.baseBiome().func_185360_m() * 2.0f;
        if (height > 1.5f || this.isTaigaBiome(this.baseBiome())) {
            return BeachType.STONE;
        }
        return BeachType.NORMAL;
    }

    private boolean isTaigaBiome(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
    }

    public static enum RiverType {
        NORMAL,
        FROZEN;

        private IRealisticBiome rtgBiome;
        private boolean locked = false;

        public static RiverType getTypeFromBiome(Biome riverBiome) {
            return riverBiome == Biomes.field_76777_m ? FROZEN : NORMAL;
        }

        public Biome getBiome() {
            return this == NORMAL ? Biomes.field_76781_i : Biomes.field_76777_m;
        }

        public IRealisticBiome getRTGBiome() {
            return this.rtgBiome;
        }

        public IRealisticBiome setRTGBiome(IRealisticBiome rtgBiome) {
            if (!this.locked) {
                this.rtgBiome = rtgBiome;
                this.locked = true;
            }
            return rtgBiome;
        }
    }

    public static enum BeachType {
        NORMAL,
        STONE,
        COLD;

        private IRealisticBiome rtgBiome;
        private boolean locked = false;

        public Biome getBiome() {
            return this == STONE ? Biomes.field_150576_N : (this == COLD ? Biomes.field_150577_O : Biomes.field_76787_r);
        }

        public IRealisticBiome getRTGBiome() {
            return this.rtgBiome;
        }

        public IRealisticBiome setRTGBiome(IRealisticBiome rtgBiome) {
            if (!this.locked) {
                this.rtgBiome = rtgBiome;
                this.locked = true;
            }
            return rtgBiome;
        }

        public BeachType getTypeFromBiome(Biome beachBiome) {
            return beachBiome == Biomes.field_150576_N ? STONE : (beachBiome == Biomes.field_150577_O ? COLD : NORMAL);
        }
    }
}

