/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import rtg.api.util.Logger;
import rtg.api.util.noise.CellularNoise;
import rtg.api.util.noise.OpenSimplexNoise;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.util.noise.SpacedCellularNoise;
import rtg.api.world.gen.RTGChunkGenSettings;

@Mod.EventBusSubscriber(modid="rtg")
public final class RTGWorld {
    public static final float ACTUAL_RIVER_PROPORTION = 0.09375f;
    public static final float RIVER_FLATTENING_ADDEND = 0.10344828f;
    private static final double RIVER_LARGE_BEND_SIZE_BASE = 140.0;
    private static final double RIVER_SMALL_BEND_SIZE_BASE = 30.0;
    private static final double RIVER_SEPARATION_BASE = 975.0;
    private static final double RIVER_VALLEY_LEVEL_BASE = 0.3111111111111111;
    private static final float LAKE_FREQUENCY_BASE = 649.0f;
    private static final float LAKE_SHORE_LEVEL_BASE = 0.035f;
    private static final float LAKE_DEPRESSION_LEVEL = 0.15f;
    private static final float LAKE_BEND_SIZE_LARGE = 80.0f;
    private static final float LAKE_BEND_SIZE_MEDIUM = 30.0f;
    private static final float LAKE_BEND_SIZE_SMALL = 12.0f;
    private static final int SIMPLEX_INSTANCE_COUNT = 10;
    private static final int CELLULAR_INSTANCE_COUNT = 5;
    private static final Map<World, RTGWorld> INSTANCE_CACHE = new HashMap<World, RTGWorld>();
    private final World world;
    private final RTGChunkGenSettings generatorSettings;
    private final SimplexNoise[] simplexNoiseInstances = new SimplexNoise[10];
    private final CellularNoise[] cellularNoiseInstances = new CellularNoise[5];
    private Random generatorRandom = null;

    private RTGWorld(World world) {
        int i;
        this.world = world;
        this.generatorSettings = RTGChunkGenSettings.Factory.jsonToFactory(world.func_72912_H().func_82571_y()).build();
        for (i = 0; i < 10; ++i) {
            this.simplexNoiseInstances[i] = new OpenSimplexNoise(this.seed() + (long)i);
        }
        for (i = 0; i < 5; ++i) {
            this.cellularNoiseInstances[i] = new SpacedCellularNoise(this.seed() + (long)i);
        }
    }

    public static RTGWorld getInstance(World world) {
        if (!INSTANCE_CACHE.containsKey(world)) {
            INSTANCE_CACHE.put(world, new RTGWorld(world));
        }
        return INSTANCE_CACHE.get(world);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Logger.debug("WorldEvent.Load: WorldType: {}, DimID: {}, DimType: {}, BiomeProvider: {}, IChunkGenerator: {}", world.func_175624_G().getClass().getSimpleName(), world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p(), world.field_73011_w.func_177499_m().getClass().getName(), ((ChunkProviderServer)world.func_72863_F()).field_186029_c.getClass().getName());
            if (world.field_73011_w.getDimension() == 0) {
                Logger.info("World Seed: " + world.func_72905_C(), new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Logger.debug("WorldEvent.Unload: WorldType: {}, DimID: {}, DimType: {}, BiomeProvider: {}, IChunkGenerator: {}", world.func_175624_G().getClass().getSimpleName(), world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p(), world.field_73011_w.func_177499_m().getClass().getName(), ((ChunkProviderServer)world.func_72863_F()).field_186029_c.getClass().getName());
        }
        INSTANCE_CACHE.remove(world);
    }

    public void setRandom(Random random) {
        if (this.generatorRandom == null) {
            this.generatorRandom = random;
        }
    }

    public World world() {
        return this.world;
    }

    public RTGChunkGenSettings getGeneratorSettings() {
        return this.generatorSettings;
    }

    public long seed() {
        return this.world().func_72905_C();
    }

    public Random rand() {
        return this.generatorRandom;
    }

    public long getChunkSeed(int chunkX, int chunkZ) {
        long seed = this.world().func_72905_C();
        Random rand = new Random(seed);
        return (long)chunkX * (rand.nextLong() / 2L * 2L + 1L) + (long)chunkZ * (rand.nextLong() / 2L * 2L + 1L) ^ seed;
    }

    public SimplexNoise simplexInstance(int index) {
        if (index >= this.simplexNoiseInstances.length) {
            index = 0;
        }
        return this.simplexNoiseInstances[index];
    }

    public CellularNoise cellularInstance(int index) {
        if (index >= this.cellularNoiseInstances.length) {
            index = 0;
        }
        return this.cellularNoiseInstances[index];
    }

    public double getRiverLargeBendSize() {
        return 140.0 * (double)this.generatorSettings.riverBendMult;
    }

    public double getRiverSmallBendSize() {
        return 30.0 * (double)this.generatorSettings.riverBendMult;
    }

    public double getRiverSeparation() {
        return 975.0 / (double)this.generatorSettings.riverFrequency;
    }

    public double getRiverValleyLevel() {
        return 0.3111111111111111 * (double)this.generatorSettings.riverSizeMult * (double)this.generatorSettings.riverFrequency;
    }

    public float getLakeFrequency() {
        return 649.0f * this.generatorSettings.RTGlakeFreqMult;
    }

    public float getLakeShoreLevel() {
        return 0.035f * this.generatorSettings.RTGlakeFreqMult * this.generatorSettings.RTGlakeSizeMult;
    }

    public float getLakeDepressionLevel() {
        return 0.15f * this.generatorSettings.RTGlakeFreqMult * this.generatorSettings.RTGlakeSizeMult;
    }

    public float getLakeBendSizeLarge() {
        return 80.0f * this.generatorSettings.RTGlakeShoreBend;
    }

    public float getLakeBendSizeMedium() {
        return 30.0f * this.generatorSettings.RTGlakeShoreBend;
    }

    public float getLakeBendSizeSmall() {
        return 12.0f * this.generatorSettings.RTGlakeShoreBend;
    }
}

