/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.storage;

import java.lang.reflect.Array;
import javax.annotation.Nullable;

public final class SimpleMultiBucketCache<T> {
    private static final int BUCKET_DIMENSION_SIZE = 8;
    private static final int BUCKET_BITMASK = 7;
    private final int bucketSize;
    private final long[][][] bucketKeys;
    private final T[][][] bucketVals;
    private final int[][] bucketIndex;
    private final ReverseHistoryIndexer indexer;

    public SimpleMultiBucketCache(Class<T> cacheType, int bucketSize) {
        this(cacheType, bucketSize, false);
    }

    public SimpleMultiBucketCache(Class<T> cacheType, int bucketSize, boolean primeIndexes) {
        this.bucketSize = bucketSize;
        this.bucketVals = (Object[][][])Array.newInstance(cacheType, 8, 8, bucketSize);
        this.bucketKeys = new long[8][8][bucketSize];
        this.bucketIndex = new int[8][8];
        if (primeIndexes) {
            for (int x2 = 0; x2 < 8; ++x2) {
                for (int z2 = 0; z2 < 8; ++z2) {
                    this.bucketIndex[x2][z2] = bucketSize - 1;
                }
            }
        }
        this.indexer = (x, z, i) -> {
            int xformedIndex = this.bucketIndex[x & 7][z & 7] - i;
            return xformedIndex < 0 ? xformedIndex + bucketSize : xformedIndex;
        };
    }

    private long getKey(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    private int nextIndex(int x, int z) {
        int index = this.bucketIndex[x][z];
        int n = ++index < this.bucketSize ? index : 0;
        this.bucketIndex[x][z] = n;
        return n;
    }

    public final void put(int x, int z, T value) {
        int bucketX = x & 7;
        int bucketZ = z & 7;
        int nextIndex = this.nextIndex(bucketX, bucketZ);
        this.bucketKeys[bucketX][bucketZ][nextIndex] = this.getKey(x, z);
        this.bucketVals[bucketX][bucketZ][nextIndex] = value;
    }

    @Nullable
    public final T get(int x, int z) {
        int bucketX = x & 7;
        int bucketZ = z & 7;
        for (int i = 0; i < this.bucketSize; ++i) {
            int index = this.indexer.getIndex(x, z, i);
            T value = this.bucketVals[bucketX][bucketZ][index];
            if (value == null || this.bucketKeys[bucketX][bucketZ][index] != this.getKey(x, z)) continue;
            return value;
        }
        return null;
    }

    @FunctionalInterface
    private static interface ReverseHistoryIndexer {
        public int getIndex(int var1, int var2, int var3);
    }
}

