/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.noise;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.Random;
import rtg.api.util.LimitedArrayCacheMap;
import rtg.api.util.noise.CellularNoise;
import rtg.api.util.noise.VoronoiResult;

public class SpacedCellularNoise
implements CellularNoise {
    private static final int totalPoints = 100;
    private static final int pointsPerTorus = 25;
    private static final double minDistanceSq = 0.005;
    private final Map<Point, Point2D.Double[]> cache = new LimitedArrayCacheMap<Point, Point2D.Double[]>(256);
    private final Point2D.Double[] allPoints;
    private final long xSeed;
    private final long ySeed;

    public SpacedCellularNoise(long xSeed) {
        this.xSeed = xSeed;
        this.ySeed = new Random(xSeed).nextLong();
        this.allPoints = new Point2D.Double[100];
        this.setPoints();
    }

    private static double minimalToroidalDistanceSquared(Point2D.Double point, Point2D.Double[] existing, int count) {
        double result = 1.0;
        for (int i = 0; i < count; ++i) {
            double distance = SpacedCellularNoise.toroidalDistanceSquared(point, existing[i]);
            if (!(distance < result)) continue;
            result = distance;
        }
        return result;
    }

    private static double toroidalDistanceSquared(Point2D.Double first, Point2D.Double second) {
        double yDist;
        double xDist = Math.abs(first.x - second.x);
        if (xDist > 0.5) {
            xDist = 1.0 - xDist;
        }
        if ((yDist = Math.abs(first.y - second.y)) > 0.5) {
            yDist = 1.0 - yDist;
        }
        return xDist * xDist + yDist * yDist;
    }

    @Override
    public VoronoiResult eval2D(double x, double y) {
        int xInt = x > 0.0 ? (int)x : (int)(x /= 5.0) - 1;
        int yInt = y > 0.0 ? (int)y : (int)(y /= 5.0) - 1;
        VoronoiResult result = new VoronoiResult();
        Point square = new Point(xInt, yInt);
        result.evaluate(this.areaPoints(square), x, y);
        double distance = y - (double)yInt;
        if (distance != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt, yInt - 1)), x, y);
        }
        if ((distance = x - (double)xInt) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt - 1, yInt)), x, y);
        }
        if ((distance = (double)yInt - y + 1.0) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt, yInt + 1)), x, y);
        }
        if ((distance = (double)xInt - x + 1.0) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt + 1, yInt)), x, y);
        }
        if ((distance = Math.min(y - (double)yInt, x - (double)xInt)) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt - 1, yInt - 1)), x, y);
        }
        if ((distance = Math.min((double)yInt - y + 1.0, x - (double)xInt)) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt - 1, yInt + 1)), x, y);
        }
        if ((distance = Math.min((double)yInt - y + 1.0, (double)xInt - x + 1.0)) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt + 1, yInt + 1)), x, y);
        }
        if ((distance = Math.min(y - (double)yInt, (double)xInt - x + 1.0)) != result.getNextDistance()) {
            result.evaluate(this.areaPoints(new Point(xInt + 1, yInt - 1)), x, y);
        }
        return result;
    }

    private Point2D.Double[] areaPoints(Point area) {
        Point2D.Double[] ret = this.cache.get(area);
        return ret != null ? ret : this.generatedAreaPoints(area);
    }

    private Point2D.Double[] generatedAreaPoints(Point area) {
        Random random = new Random(area.hashCode());
        boolean[] used = new boolean[100];
        Point2D.Double[] result = new Point2D.Double[25];
        int index = 0;
        for (int i = 0; i < 25; ++i) {
            int advance = random.nextInt(100);
            for (int j = 0; j < advance; ++j) {
                while (used[index]) {
                    if (++index < 100) continue;
                    index = 0;
                }
            }
            result[i] = new Point2D.Double(this.allPoints[index].getX() + area.getX(), this.allPoints[index].getY() + area.getY());
            used[i] = true;
        }
        this.cache.put(area, result);
        return result;
    }

    private void setPoints() {
        Random xRandom = new Random(this.xSeed);
        Random yRandom = new Random(this.ySeed);
        int i = 0;
        while (i < 100) {
            Point2D.Double newPoint = new Point2D.Double(xRandom.nextDouble(), yRandom.nextDouble());
            if (!(SpacedCellularNoise.minimalToroidalDistanceSquared(newPoint, this.allPoints, i) >= 0.005)) continue;
            this.allPoints[i++] = newPoint;
        }
    }
}

