/*
 * Decompiled with CFR 0.152.
 */
package rtg.api;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;
import rtg.api.util.Logger;
import rtg.api.util.storage.SparseList;
import rtg.api.world.biome.IRealisticBiome;
import rtg.world.WorldTypeRTG;

public final class RTGAPI {
    public static final String RTG_API_ID = "rtgapi";
    public static final String VERSION = "1.1.0";
    public static final String RTG_MOD_ID = "rtg";
    public static final String RTG_WORLDTYPE_ID = "RTG";
    public static final SparseList<Map.Entry<Biome, IRealisticBiome>> RTG_BIOMES = new SparseList();
    private static final Set<DimensionType> ALLOWED_DIMENSION_TYPES = new ObjectArraySet();
    private static boolean rtgBiomesLocked = false;
    private static Path configPath;
    private static Path biomeConfigPath;
    private static IRealisticBiome patchBiome;
    private static IBlockState shadowStoneBlock;
    private static IBlockState shadowDesertBlock;

    private RTGAPI() {
    }

    public static void lockRtgBiomes() {
        rtgBiomesLocked = true;
    }

    public static Path getConfigPath() {
        return configPath;
    }

    public static void setConfigPath(Path path) {
        if (configPath == null) {
            configPath = path;
            biomeConfigPath = path.resolve("biomes");
        }
    }

    public static Path getBiomeConfigPath() {
        return biomeConfigPath;
    }

    public static boolean checkWorldType(WorldType worldType) {
        return ((Object)((Object)WorldTypeRTG.getInstance())).equals(worldType);
    }

    public static void addAllowedDimensionType(DimensionType dimType) {
        ALLOWED_DIMENSION_TYPES.add(dimType);
    }

    public static void removeAllowedDimensionType(DimensionType dimType) {
        ALLOWED_DIMENSION_TYPES.remove(dimType);
    }

    public static boolean isAllowedDimensionType(DimensionType dimType) {
        return ALLOWED_DIMENSION_TYPES.contains(dimType) || dimType.func_186067_c().equals("_rtg") || dimType.name().startsWith("jed_surface");
    }

    public static boolean isAllowedDimensionType(int dimId) {
        DimensionType type = DimensionManager.isDimensionRegistered((int)dimId) ? DimensionManager.getProviderType((int)dimId) : null;
        return type != null && RTGAPI.isAllowedDimensionType(type);
    }

    public static IRealisticBiome getRTGBiome(@Nonnull Biome biome) {
        Map.Entry<Biome, IRealisticBiome> entry = RTG_BIOMES.get(Biome.func_185362_a((Biome)biome));
        if (entry != null) {
            return entry.getValue();
        }
        return patchBiome;
    }

    public static IRealisticBiome getRTGBiome(int biomeId) {
        Map.Entry<Biome, IRealisticBiome> entry = RTG_BIOMES.get(biomeId);
        if (entry != null) {
            return entry.getValue();
        }
        return patchBiome;
    }

    public static void addRTGBiomes(IRealisticBiome ... biomes) {
        if (!rtgBiomesLocked) {
            for (IRealisticBiome biome : biomes) {
                Biome baseBiome = biome.baseBiome();
                RTG_BIOMES.set(Biome.func_185362_a((Biome)baseBiome), (Map.Entry<Biome, IRealisticBiome>)new AbstractMap.SimpleEntry<Biome, IRealisticBiome>(baseBiome, biome));
            }
        }
    }

    public static void initPatchBiome(Biome biome) {
        IRealisticBiome rtgBiome = RTGAPI.getRTGBiome(biome);
        if (rtgBiome == null) {
            Logger.error("Erroneous patch biome set in config: {} (no RTG version), Using default.", biome.getRegistryName());
            rtgBiome = Objects.requireNonNull(RTGAPI.getRTGBiome(Biomes.field_76772_c), "Cannot find an RTG version of minecraft:plains. This should be impossible.");
        }
        Logger.debug("Setting patch biome to: {}", rtgBiome.baseBiomeResLoc());
        patchBiome = rtgBiome;
    }

    public static void setShadowBlocks(@Nullable IBlockState stone, @Nullable IBlockState desert) {
        if (shadowStoneBlock == null) {
            IBlockState iBlockState = shadowStoneBlock = stone != null ? stone : Blocks.field_150348_b.func_176223_P();
        }
        if (shadowDesertBlock == null) {
            shadowDesertBlock = desert != null ? desert : Blocks.field_150354_m.func_176223_P();
        }
    }

    public static IBlockState getShadowStoneBlock() {
        return shadowStoneBlock;
    }

    public static IBlockState getShadowDesertBlock() {
        return shadowDesertBlock;
    }

    public static int getMaxBiomeIDs() {
        if (Loader.isModLoaded((String)"jeid")) {
            return 65536;
        }
        return 256;
    }

    public static void dumpGenLayerStack(@Nonnull GenLayer layersIn, Level level) {
        ArrayList initialStack = Lists.newArrayList();
        ArrayList riverStack = Lists.newArrayList();
        ArrayList biomeStack = Lists.newArrayList();
        int count = 0;
        GenLayer layer = layersIn;
        initialStack.add(String.format("%s. %s", ++count, layer.getClass().getName()));
        while (layer.field_75909_a != null) {
            initialStack.add(String.format("%s. %s", ++count, layer.field_75909_a.getClass().getName()));
            layer = layer.field_75909_a;
        }
        if (layer instanceof GenLayerRiverMix) {
            int rivercount;
            int biomecount = rivercount = count;
            GenLayer biomeLayer = ((GenLayerRiverMix)layer).field_75910_b;
            while (biomeLayer.field_75909_a != null) {
                biomeStack.add(String.format("%s. %s", ++biomecount, biomeLayer.field_75909_a.getClass().getName()));
                biomeLayer = biomeLayer.field_75909_a;
            }
            GenLayer riverLayer = ((GenLayerRiverMix)layer).field_75911_c;
            while (riverLayer.field_75909_a != null) {
                riverStack.add(String.format("%s. %s", ++rivercount, riverLayer.field_75909_a.getClass().getName()));
                riverLayer = riverLayer.field_75909_a;
            }
        }
        if (biomeStack.isEmpty() || riverStack.isEmpty()) {
            Logger.log(level, "\nGenLayer stack:\n{}", String.join((CharSequence)"\n  ", initialStack));
        } else {
            Logger.log(level, "\nInitial GenLayer stack:\n  {}\nBiome GenLayer stack:\n  {}\nRiver GenLayer stack:\n  {}", String.join((CharSequence)"\n  ", initialStack), String.join((CharSequence)"\n  ", biomeStack), String.join((CharSequence)"\n  ", riverStack));
        }
    }

    static {
        shadowStoneBlock = null;
        shadowDesertBlock = null;
    }
}

