/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.incubator;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.blocks.ItemStackHandlerControl;
import com.theundertaker11.geneticsreborn.blocks.StorageBlockBase;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.potions.GRPotions;
import com.theundertaker11.geneticsreborn.tile.GRTileEntityBasicEnergyReceiver;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GRTileEntityIncubator
extends GRTileEntityBasicEnergyReceiver
implements ITickable {
    private boolean advanced;
    private boolean lowTemp;
    private boolean brewComplete;
    private ItemStackHandler guiStackHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            GRTileEntityIncubator.this.func_70296_d();
            if (GRTileEntityIncubator.this.brewComplete) {
                boolean empty = true;
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
                    empty = false;
                }
                if (empty) {
                    GRTileEntityIncubator.this.setBrewComplete(false);
                }
            }
        }
    };
    private ItemStackHandler inputStackHandler = new ItemStackHandlerControl(this.guiStackHandler){

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (GRTileEntityIncubator.this.brewComplete) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private ItemStackHandler outputStackHandler = new ItemStackHandlerControl(this.guiStackHandler){

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!GRTileEntityIncubator.this.brewComplete) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private ItemStackHandler ingredientStackHandler = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            GRTileEntityIncubator.this.func_70296_d();
            GRTileEntityIncubator.this.setBrewComplete(false);
        }
    };
    private ItemStackHandler fuelStackHandler = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            GRTileEntityIncubator.this.func_70296_d();
        }
    };
    private static final byte TEMP_FIELD_ID = 3;
    private static final byte BREW_FIELD_ID = 4;

    public GRTileEntityIncubator() {
    }

    public GRTileEntityIncubator(String name) {
        this(name, false);
    }

    public GRTileEntityIncubator(String name, boolean a) {
        super(name);
        this.advanced = a;
        this.lowTemp = false;
        this.brewComplete = false;
        this.NUMBER_OF_FIELDS = (byte)4;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isBrewComplete() {
        return this.brewComplete;
    }

    private void setBrewComplete(boolean v) {
        this.brewComplete = v;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(enumfacing), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), this.field_174879_c);
            }
        }
    }

    public boolean isLowTemp() {
        return this.lowTemp;
    }

    public void setTemp(boolean low) {
        this.lowTemp = low;
        this.ticksCooking = 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int rfpertick = this.lowTemp ? GeneticsReborn.baseRfPerTickIncubatorLow : GeneticsReborn.baseRfPerTickIncubatorHigh + this.overclockers * 85;
        double totalTicks = (double)(this.lowTemp ? GeneticsReborn.baseTickIncubatorLow : GeneticsReborn.baseTickIncubatorHigh) - (double)(this.overclockers * 39);
        if (this.canBrew()) {
            if (this.storage.getEnergyStored() > rfpertick) {
                this.storage.extractEnergy(rfpertick, false);
                ++this.ticksCooking;
                this.func_70296_d();
            }
            if (this.ticksCooking < 0) {
                this.ticksCooking = 0;
            }
            if ((double)this.ticksCooking >= totalTicks) {
                this.ticksCooking = 0;
                this.finishBrew();
            }
        } else {
            this.ticksCooking = 0;
        }
    }

    private void finishBrew() {
        this.setBrewComplete(true);
        ItemStack ingredient = this.ingredientStackHandler.getStackInSlot(0);
        ItemStack input = this.inputStackHandler.getStackInSlot(0);
        PotionType pot = PotionUtils.func_185191_c((ItemStack)input);
        ItemStack fuel = this.fuelStackHandler.getStackInSlot(0);
        for (int i = 0; i < this.guiStackHandler.getSlots(); ++i) {
            ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)this.guiStackHandler.getStackInSlot(i), (ItemStack)ingredient);
            if (output.func_190926_b()) continue;
            if (this.lowTemp && pot == GRPotions.SUBSTRATE && output.func_77973_b() == GRItems.Cell) {
                output.func_190920_e(6);
            }
            if (this.lowTemp && output.func_77942_o() && output.func_77978_p().func_74764_b("forceGene")) {
                output.func_77978_p().func_74757_a("lowTemp", true);
                if (this.overclockers > 0 && fuel.func_190926_b()) {
                    output.func_77978_p().func_74768_a("overclocked", this.overclockers);
                }
            }
            this.guiStackHandler.setStackInSlot(i, output);
        }
        if (this.lowTemp && !fuel.func_190926_b()) {
            fuel.func_190918_g(1);
        }
        ingredient.func_190918_g(1);
        this.func_70296_d();
    }

    public boolean isBrewing() {
        return this.canBrew();
    }

    public boolean hasPower() {
        return this.storage.canExtract();
    }

    private boolean canBrew() {
        return this.hasPower() && !this.brewComplete && BrewingRecipeRegistry.hasOutput((ItemStack)this.inputStackHandler.getStackInSlot(0), (ItemStack)this.ingredientStackHandler.getStackInSlot(0)) || BrewingRecipeRegistry.hasOutput((ItemStack)this.inputStackHandler.getStackInSlot(1), (ItemStack)this.ingredientStackHandler.getStackInSlot(0)) || BrewingRecipeRegistry.hasOutput((ItemStack)this.inputStackHandler.getStackInSlot(2), (ItemStack)this.ingredientStackHandler.getStackInSlot(0));
    }

    @Override
    public double getTotalTicks() {
        return (double)(this.lowTemp ? GeneticsReborn.baseTickIncubatorLow : GeneticsReborn.baseTickIncubatorHigh) - (double)(this.overclockers * 39);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("advanced", this.advanced);
        compound.func_74757_a("lowTemp", this.lowTemp);
        compound.func_74757_a("complete", this.brewComplete);
        compound.func_74782_a("ingredients", (NBTBase)this.ingredientStackHandler.serializeNBT());
        compound.func_74782_a("fuel", (NBTBase)this.fuelStackHandler.serializeNBT());
        compound.func_74782_a("potions", (NBTBase)this.guiStackHandler.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.advanced = compound.func_74767_n("advanced");
        this.lowTemp = compound.func_74767_n("lowTemp");
        this.setBrewComplete(compound.func_74767_n("complete"));
        this.ingredientStackHandler.deserializeNBT(compound.func_74775_l("ingredients"));
        this.fuelStackHandler.deserializeNBT(compound.func_74775_l("fuel"));
        this.guiStackHandler.deserializeNBT(compound.func_74775_l("potions"));
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.guiStackHandler;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.ingredientStackHandler;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.outputStackHandler;
            }
            IBlockState bs = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (bs.func_177230_c() == Blocks.field_150350_a) {
                return (T)this.fuelStackHandler;
            }
            EnumFacing blockFacing = (EnumFacing)bs.func_177229_b((IProperty)StorageBlockBase.FACING);
            if (blockFacing == EnumFacing.NORTH || blockFacing == EnumFacing.SOUTH) {
                if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                    return (T)this.inputStackHandler;
                }
                if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                    return (T)this.fuelStackHandler;
                }
            } else {
                if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                    return (T)this.fuelStackHandler;
                }
                if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                    return (T)this.inputStackHandler;
                }
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getField(int id) {
        if (id == 3) {
            return this.lowTemp ? 1 : 0;
        }
        if (id == 4) {
            return this.brewComplete ? 1 : 0;
        }
        return super.getField(id);
    }

    @Override
    public void setField(int id, int value) {
        if (id == 3) {
            this.setTemp(value == 1);
        } else if (id == 4) {
            this.setBrewComplete(value == 1);
        } else {
            super.setField(id, value);
        }
    }
}

