/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.util;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.util.LangKeys;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.command.ICommandSender;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public final class ChatUtil {
    public static final String RAW_PREFIX = "[\u26a1] ";
    public static final ITextComponent RESET = new TextComponentString("");
    public static final ITextComponent PREFIX = new TextComponentString("[");
    private static final Map<String, LangKeys> langKeys = new Object2ObjectOpenHashMap();

    public static ITextComponent prefix(ITextComponent message) {
        return PREFIX.func_150259_f().func_150257_a(RESET.func_150259_f()).func_150257_a(message.func_150259_f());
    }

    public static boolean doesLangKeysExist(String langKey) {
        return langKeys.containsKey(langKey);
    }

    public static void sendMessage(FlareAPI flare, ICommandSender sender, ITextComponent textComponent) {
        if (textComponent instanceof TextComponentTranslation) {
            TextComponentTranslation langKey = (TextComponentTranslation)textComponent;
            String rawLangKeys = langKey.func_150268_i();
            LangKeys defaultResponse = langKeys.get(rawLangKeys);
            if (defaultResponse != null) {
                ChatUtil.sendMessage(flare, sender, defaultResponse, langKey.func_150271_j());
            } else {
                ChatUtil.sendMessage(flare, sender, LangKeys.ERROR, langKey.func_150271_j());
            }
        } else if (sender instanceof RConConsoleSource || sender instanceof MinecraftServer || sender == null) {
            flare.logger().warn(textComponent.func_150260_c());
        } else {
            sender.func_145747_a(textComponent);
        }
    }

    public static void sendMessage(FlareAPI flare, ICommandSender sender, LangKeys langKey, Object ... formatArgs) {
        if (sender instanceof RConConsoleSource || sender instanceof MinecraftServer || sender == null) {
            flare.logger().warn(String.format(langKey.defaultText, formatArgs));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(langKey.langKey, formatArgs));
        }
    }

    public static void sendMessage(FlareAPI flare, ICommandSender sender, LangKeys langKey, Consumer<TextComponentTranslation> unaryOperator, Object ... formatArgs) {
        if (sender instanceof RConConsoleSource || sender instanceof MinecraftServer || sender == null) {
            flare.logger().warn(String.format(langKey.defaultText, formatArgs));
        } else {
            TextComponentTranslation text = new TextComponentTranslation(langKey.langKey, formatArgs);
            unaryOperator.accept(text);
            sender.func_145747_a((ITextComponent)text);
        }
    }

    private ChatUtil() {
    }

    static {
        RESET.func_150256_b().func_150238_a(TextFormatting.RESET);
        PREFIX.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY).func_150227_a(Boolean.valueOf(true));
        TextComponentString symbol = new TextComponentString("\u26a1");
        symbol.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150227_a(Boolean.valueOf(true));
        PREFIX.func_150257_a((ITextComponent)symbol);
        TextComponentString closingBracket = new TextComponentString("] ");
        closingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        PREFIX.func_150257_a((ITextComponent)closingBracket);
        for (LangKeys langKey : LangKeys.values()) {
            langKeys.put(langKey.langKey, langKey);
        }
    }
}

