/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.source;

import com.cleanroommc.flare.api.sampler.source.ClassSourceLookup;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;

public class FlareClassSourceLookup
implements ClassSourceLookup {
    private final ASMDataTable asmDataTable;

    public FlareClassSourceLookup() {
        try {
            Field modApiManager$dataTable = ModAPIManager.class.getDeclaredField("dataTable");
            modApiManager$dataTable.setAccessible(true);
            this.asmDataTable = (ASMDataTable)modApiManager$dataTable.get(ModAPIManager.INSTANCE);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    @Nullable
    public String identify(String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        if (packageName.startsWith("net.minecraft")) {
            if (packageName.charAt(13) == '.') {
                return "Minecraft";
            }
            return "Forge";
        }
        Set candidates = this.asmDataTable.getCandidatesFor(packageName);
        if (candidates.isEmpty()) {
            return null;
        }
        return candidates.stream().map(ModCandidate::getContainedMods).flatMap(Collection::stream).map(ModContainer::getName).collect(Collectors.joining(", "));
    }
}

