/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.async;

import com.cleanroommc.flare.api.sampler.SamplerMode;
import com.cleanroommc.flare.common.sampler.async.AsyncProfilerAccess;
import com.cleanroommc.flare.common.sampler.async.jfr.JfrReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public interface SampleCollector<E extends JfrReader.Event> {
    public Collection<String> initArguments(AsyncProfilerAccess var1);

    public Class<E> eventClass();

    public long measure(E var1);

    public SamplerMode mode();

    public static final class Allocation
    implements SampleCollector<JfrReader.AllocationSample> {
        private final int intervalBytes;
        private final boolean liveOnly;

        public Allocation(int intervalBytes, boolean liveOnly) {
            this.intervalBytes = intervalBytes;
            this.liveOnly = liveOnly;
        }

        public boolean isLiveOnly() {
            return this.liveOnly;
        }

        @Override
        public Collection<String> initArguments(AsyncProfilerAccess access) {
            AsyncProfilerAccess.ProfilingEvent event = access.getAllocationProfilingEvent();
            Preconditions.checkNotNull((Object)((Object)event));
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)("event=" + (Object)((Object)event)));
            builder.add((Object)("alloc=" + this.intervalBytes));
            if (this.liveOnly) {
                builder.add((Object)"live");
            }
            return builder.build();
        }

        @Override
        public Class<JfrReader.AllocationSample> eventClass() {
            return JfrReader.AllocationSample.class;
        }

        @Override
        public long measure(JfrReader.AllocationSample event) {
            return event.value();
        }

        @Override
        public SamplerMode mode() {
            return SamplerMode.ALLOCATION;
        }
    }

    public static final class Execution
    implements SampleCollector<JfrReader.ExecutionSample> {
        private final int interval;

        public Execution(int interval) {
            this.interval = interval;
        }

        @Override
        public Collection<String> initArguments(AsyncProfilerAccess access) {
            AsyncProfilerAccess.ProfilingEvent event = access.getProfilingEvent();
            Preconditions.checkNotNull((Object)((Object)event));
            return ImmutableList.of((Object)("event=" + (Object)((Object)event)), (Object)("interval=" + this.interval + "us"));
        }

        @Override
        public Class<JfrReader.ExecutionSample> eventClass() {
            return JfrReader.ExecutionSample.class;
        }

        @Override
        public long measure(JfrReader.ExecutionSample event) {
            return event.value() * (long)this.interval;
        }

        @Override
        public SamplerMode mode() {
            return SamplerMode.EXECUTION;
        }
    }
}

