/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.async;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.common.sampler.async.AsyncProfilerJob;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.stream.Collectors;
import one.profiler.AsyncProfiler;

public class AsyncProfilerAccess {
    private static AsyncProfilerAccess instance;
    private final AsyncProfiler profiler;
    private final ProfilingEvent profilingEvent;
    private final ProfilingEvent allocationProfilingEvent;
    private final Exception setupException;

    public static synchronized AsyncProfilerAccess getInstance(FlareAPI flare) {
        if (instance == null) {
            Preconditions.checkNotNull((Object)flare, (Object)"FlareAPI must not be null");
            instance = new AsyncProfilerAccess(flare);
        }
        return instance;
    }

    private AsyncProfilerAccess(FlareAPI flare) {
        AsyncProfiler profiler;
        ProfilingEvent profilingEvent = null;
        ProfilingEvent allocationProfilingEvent = null;
        Exception setupException = null;
        try {
            profiler = AsyncProfilerAccess.load(flare);
            if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.ALLOC, false)) {
                allocationProfilingEvent = ProfilingEvent.ALLOC;
            }
            if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.CPU, false)) {
                profilingEvent = ProfilingEvent.CPU;
            } else if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.WALL, true)) {
                profilingEvent = ProfilingEvent.WALL;
            }
        }
        catch (Exception e) {
            profiler = null;
            setupException = e;
        }
        this.profiler = profiler;
        this.profilingEvent = profilingEvent;
        this.allocationProfilingEvent = allocationProfilingEvent;
        this.setupException = setupException;
    }

    public AsyncProfilerJob startNewProfilerJob() {
        if (this.profiler == null) {
            throw new UnsupportedOperationException("async-profiler not supported", this.setupException);
        }
        return AsyncProfilerJob.createNew(this, this.profiler);
    }

    public ProfilingEvent getProfilingEvent() {
        return this.profilingEvent;
    }

    public ProfilingEvent getAllocationProfilingEvent() {
        return this.allocationProfilingEvent;
    }

    public boolean checkSupported(FlareAPI flare) {
        if (this.setupException != null) {
            if (this.setupException instanceof UnsupportedSystemException) {
                flare.logger().info("The async-profiler engine is not supported for your os/arch ({}),so the built-in Java engine will be used instead.", (Object)this.setupException.getMessage());
            } else if (this.setupException instanceof NativeLoadingException && this.setupException.getCause().getMessage().contains("libstdc++")) {
                flare.logger().warn("Unable to initialise the async-profiler engine because libstdc++ is not installed.");
                flare.logger().warn("Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler#install-libstdc", (Throwable)this.setupException);
            } else {
                flare.logger().warn("Unable to initialise the async-profiler engine: {}", (Object)this.setupException.getMessage());
                flare.logger().warn("Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler", (Throwable)this.setupException);
            }
        }
        return this.profiler != null;
    }

    public boolean checkAllocationProfilingSupported(FlareAPI flare) {
        boolean supported;
        boolean bl = supported = this.allocationProfilingEvent != null;
        if (!supported && this.profiler != null) {
            flare.logger().warn("The allocation profiling mode is not supported on your system. This is most likely because Hotspot debug symbols are not available.");
            flare.logger().warn("To resolve, try installing the 'openjdk-11-dbg' or 'openjdk-8-dbg' package using your OS package manager.");
        }
        return supported;
    }

    private static AsyncProfiler load(FlareAPI flare) throws Exception {
        ImmutableTable supported;
        String libPath;
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT).replace(" ", "");
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (os.equals("linux") && arch.equals("amd64") && AsyncProfilerAccess.isLinuxMusl()) {
            arch = "amd64-musl";
        }
        if ((libPath = (String)(supported = ImmutableTable.builder().put((Object)"linux", (Object)"amd64", (Object)"linux/amd64").put((Object)"linux", (Object)"amd64-musl", (Object)"linux/amd64-musl").put((Object)"linux", (Object)"aarch64", (Object)"linux/aarch64").put((Object)"macosx", (Object)"amd64", (Object)"macos").put((Object)"macosx", (Object)"aarch64", (Object)"macos").build()).get((Object)os, (Object)arch)) == null) {
            throw new UnsupportedSystemException(os, arch);
        }
        String resource = "flare/" + libPath + "/libasyncProfiler.so";
        URL profilerResource = AsyncProfilerAccess.class.getClassLoader().getResource(resource);
        if (profilerResource == null) {
            throw new IllegalStateException("Could not find " + resource + " in flare's jar file");
        }
        Path extractPath = Files.createTempFile("flare-", "-libasyncProfiler.so.tmp", new FileAttribute[0]);
        try (InputStream in = profilerResource.openStream();
             OutputStream out = Files.newOutputStream(extractPath, new OpenOption[0]);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        try {
            return AsyncProfiler.getInstance(extractPath.toAbsolutePath().toString());
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeLoadingException(e);
        }
    }

    private static boolean isEventSupported(AsyncProfiler profiler, ProfilingEvent event, boolean throwException) {
        block4: {
            try {
                String resp = profiler.execute("check,event=" + (Object)((Object)event)).trim();
                if (resp.equalsIgnoreCase("ok")) {
                    return true;
                }
                if (throwException) {
                    throw new IllegalArgumentException(resp);
                }
            }
            catch (Exception e) {
                if (!throwException) break block4;
                throw new RuntimeException("Event " + (Object)((Object)event) + " is not supported", e);
            }
        }
        return false;
    }

    private static boolean isLinuxMusl() {
        try {
            InputStream stream = new ProcessBuilder("sh", "-c", "ldd `which ls`").start().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String output = reader.lines().collect(Collectors.joining());
            return output.contains("musl");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static final class NativeLoadingException
    extends RuntimeException {
        public NativeLoadingException(Throwable cause) {
            super("A runtime error occurred whilst loading the native library", cause);
        }
    }

    private static final class UnsupportedSystemException
    extends UnsupportedOperationException {
        public UnsupportedSystemException(String os, String arch) {
            super(os + '/' + arch);
        }
    }

    static enum ProfilingEvent {
        CPU("cpu"),
        WALL("wall"),
        ALLOC("alloc");

        private final String id;

        private ProfilingEvent(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

