/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.async;

import com.cleanroommc.flare.api.sampler.node.description.NodeDescriber;
import com.cleanroommc.flare.api.sampler.node.description.NodeDescription;
import com.cleanroommc.flare.api.sampler.node.type.ThreadNode;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.common.sampler.aggregator.AbstractDataAggregator;
import com.cleanroommc.flare.common.sampler.async.AsyncStackTraceElement;
import com.cleanroommc.flare.common.sampler.async.ProfileSegment;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.ProtoUtil;

public class AsyncDataAggregator
extends AbstractDataAggregator {
    private static final NodeDescriber<AsyncStackTraceElement> DESCRIBER = (element, parent) -> new NodeDescription(element.className(), element.methodName(), element.methodDescription());

    protected AsyncDataAggregator(ThreadGrouper threadGrouper) {
        super(threadGrouper);
    }

    public void insertData(ProfileSegment element, int window) {
        try {
            ThreadNode node = this.getNode(this.threadGrouper.group(element.getNativeThreadId(), element.getThreadName()));
            node.trace(DESCRIBER, element.getStackTrace(), element.getValue(), window);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public FlareSamplerProtos.SamplerMetadata.DataAggregator toProto() {
        return (FlareSamplerProtos.SamplerMetadata.DataAggregator)FlareSamplerProtos.SamplerMetadata.DataAggregator.newBuilder().setType(FlareSamplerProtos.SamplerMetadata.DataAggregator.Type.SIMPLE).setThreadGrouper(ProtoUtil.getThreadGrouperProto(this.threadGrouper)).build();
    }
}

