/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.metadata.MetadataProvider;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.api.sampler.node.MethodDescriptorResolver;
import com.cleanroommc.flare.api.sampler.node.type.ThreadNode;
import com.cleanroommc.flare.api.sampler.source.ClassSourceLookup;
import com.cleanroommc.flare.api.sampler.source.SourceMetadata;
import com.cleanroommc.flare.api.sampler.thread.ThreadDumper;
import com.cleanroommc.flare.common.component.memory.heap.gc.GarbageCollectorStatistics;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.common.sampler.aggregator.DataAggregator;
import com.cleanroommc.flare.common.sampler.window.ProtoTimeEncoder;
import com.cleanroommc.flare.common.sampler.window.WindowStatisticsCollector;
import com.cleanroommc.flare.common.websocket.ViewerSocket;
import com.cleanroommc.flare.proto.FlareProtos;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.ProtoUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractSampler
implements Sampler {
    protected final FlareAPI flare;
    protected final int interval;
    protected final ThreadDumper threadDumper;
    protected final long autoEndTime;
    protected final WindowStatisticsCollector windowStatisticsCollector;
    protected long startTime = -1L;
    protected boolean background;
    protected Map<String, GarbageCollectorStatistics> initialGcStats;
    protected List<ViewerSocket> viewerSockets = new CopyOnWriteArrayList<ViewerSocket>();
    protected CompletableFuture<Sampler> future = new CompletableFuture();

    protected AbstractSampler(FlareAPI flare, int interval, ThreadDumper threadDumper, long endTime, boolean runningInBackground) {
        this.flare = flare;
        this.interval = interval;
        this.threadDumper = threadDumper;
        this.autoEndTime = endTime;
        this.background = runningInBackground;
        this.windowStatisticsCollector = new WindowStatisticsCollector(flare);
    }

    protected abstract void startWork();

    protected abstract void stopWork(boolean var1);

    public abstract FlareSamplerProtos.SamplerData toProto(FlareAPI var1, ExportProps var2, boolean var3);

    @Override
    public long startTime() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Sampler not yet started.");
        }
        return this.startTime;
    }

    @Override
    public long autoEndTime() {
        return this.autoEndTime;
    }

    @Override
    public boolean runningInBackground() {
        return this.background;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        this.startWork();
    }

    @Override
    public void stop(boolean cancelled) {
        this.windowStatisticsCollector.stop();
        for (ViewerSocket viewerSocket : this.viewerSockets) {
            viewerSocket.processSamplerStopped(this);
        }
        this.stopWork(cancelled);
    }

    public void attachSocket(ViewerSocket socket) {
        this.viewerSockets.add(socket);
    }

    public Collection<ViewerSocket> getAttachedSockets() {
        return this.viewerSockets;
    }

    protected void processWindowRotate() {
        this.viewerSockets.removeIf(socket -> {
            if (!socket.isOpen()) {
                return true;
            }
            socket.processWindowRotate(this);
            return false;
        });
    }

    protected void sendStatisticsToSocket() {
        try {
            this.viewerSockets.removeIf(socket -> !socket.isOpen());
            if (this.viewerSockets.isEmpty()) {
                return;
            }
            FlareProtos.PlatformStatistics platformStats = ProtoUtil.getPlatformStatsProto(this.flare, false, this.getInitialGcStats());
            FlareProtos.SystemStatistics systemStats = ProtoUtil.getSystemStatsProto();
            for (ViewerSocket viewerSocket : this.viewerSockets) {
                viewerSocket.sendUpdatedStatistics(platformStats, systemStats);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void recordInitialGcStats() {
        this.initialGcStats = GarbageCollectorStatistics.pollStats();
    }

    protected Map<String, GarbageCollectorStatistics> getInitialGcStats() {
        return this.initialGcStats;
    }

    protected void writeMetadataToProto(FlareSamplerProtos.SamplerData.Builder proto, ExportProps props, DataAggregator dataAggregator) {
        int totalTicks;
        FlareSamplerProtos.SamplerMetadata.Builder builder = FlareSamplerProtos.SamplerMetadata.newBuilder().setSamplerMode(ProtoUtil.getSamplerModeProto(this.mode())).setPlatformMetadata(ProtoUtil.getPlatformMetadataProto()).setCreator(ProtoUtil.getCommandSenderProto(props.creator())).setStartTime(this.startTime).setInterval(this.interval).setEndTime(System.currentTimeMillis()).setThreadDumper(ProtoUtil.getThreadDumperProto(this.threadDumper)).setDataAggregator(dataAggregator.toProto());
        if (props.comment() != null) {
            builder.setComment(props.comment());
        }
        if ((totalTicks = this.windowStatisticsCollector.getTotalTicks()) != -1) {
            builder.setNumberOfTicks(totalTicks);
        }
        builder.setPlatformStatistics(ProtoUtil.getPlatformStatsProto(this.flare, true, this.getInitialGcStats()));
        builder.setSystemStatistics(ProtoUtil.getSystemStatsProto());
        MetadataProvider extraMetadataProvider = this.flare.metadataProvider();
        if (extraMetadataProvider != null) {
            builder.putAllExtraPlatformMetadata(extraMetadataProvider.export());
        }
        for (SourceMetadata sourceMetadata : this.flare.sourceMetadata()) {
            builder.putSources(sourceMetadata.name().toLowerCase(Locale.ROOT), ProtoUtil.getSourceMetadataProto(sourceMetadata));
        }
        proto.setMetadata(builder);
    }

    protected void writeDataToProto(FlareSamplerProtos.SamplerData.Builder proto, DataAggregator dataAggregator, ExportProps exportProps) {
        try {
            List<ThreadNode> data = dataAggregator.exportData();
            data.sort(Comparator.comparing(ThreadNode::label));
            ClassSourceLookup.Visitor classSourceVisitor = ClassSourceLookup.createVisitor(exportProps.classSourceLookup().get());
            ProtoTimeEncoder timeEncoder = new ProtoTimeEncoder(this.mode(), data);
            int[] timeWindows = timeEncoder.getKeys();
            FlareAPI.getInstance().logger().warn("Time Windows: {}", (Object)Arrays.toString(timeWindows));
            for (int timeWindow : timeWindows) {
                proto.addTimeWindows(timeWindow);
            }
            this.windowStatisticsCollector.ensureHasStatisticsForAllWindows(timeWindows);
            proto.putAllTimeWindowStatistics(this.windowStatisticsCollector.export());
            MethodDescriptorResolver resolver = exportProps.resolver().get();
            for (ThreadNode entry : data) {
                proto.addThreads(ProtoUtil.getThreadNodeProto(entry, timeEncoder, resolver, exportProps.separateParentCalls()));
                classSourceVisitor.visit(entry);
            }
            if (classSourceVisitor.hasClassSourceMappings()) {
                proto.putAllClassSources(classSourceVisitor.getClassSourceMapping());
            }
            if (classSourceVisitor.hasMethodSourceMappings()) {
                proto.putAllMethodSources(classSourceVisitor.getMethodSourceMapping());
            }
            if (classSourceVisitor.hasLineSourceMappings()) {
                proto.putAllLineSources(classSourceVisitor.getLineSourceMapping());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

