/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.tick;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public interface ReportPredicate {
    public boolean shouldReport(double var1, double var3, double var5);

    public ITextComponent getMonitoringStartMessage();

    public static final class DurationGt
    implements ReportPredicate {
        private final double threshold;

        public DurationGt(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean shouldReport(double duration, double increaseFromAvg, double percentageChange) {
            if (increaseFromAvg <= 0.0) {
                return false;
            }
            return duration > this.threshold;
        }

        @Override
        public ITextComponent getMonitoringStartMessage() {
            return new TextComponentTranslation("flare.message.monitoring_start.greater_duration", new Object[]{this.threshold});
        }
    }

    public static final class PercentageChangeGt
    implements ReportPredicate {
        private final double threshold;

        public PercentageChangeGt(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean shouldReport(double duration, double increaseFromAvg, double percentageChange) {
            if (increaseFromAvg <= 0.0) {
                return false;
            }
            return percentageChange > this.threshold;
        }

        @Override
        public ITextComponent getMonitoringStartMessage() {
            return new TextComponentTranslation("flare.message.monitoring_start.percentage_change", new Object[]{this.threshold});
        }
    }
}

