/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.ping;

import com.cleanroommc.flare.api.ping.PingStatistics;
import com.cleanroommc.flare.api.ping.PingSummary;
import com.cleanroommc.flare.api.ping.PlayerPing;
import com.cleanroommc.flare.util.MonitoringExecutor;
import com.cleanroommc.flare.util.RollingAverage;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class FlarePingStatistics
implements PingStatistics,
Runnable {
    private static final int QUERY_RATE_SECONDS = 10;
    private static final int WINDOW_SIZE_SECONDS = (int)TimeUnit.MINUTES.toSeconds(15L);
    private static final int WINDOW_SIZE = WINDOW_SIZE_SECONDS / 10;
    private final RollingAverage rollingAverage = new RollingAverage(WINDOW_SIZE);
    private ScheduledFuture<?> future;
    private MinecraftServer server;

    @Override
    public void run() {
        PingSummary summary = this.currentSummary();
        if (summary.total() == 0) {
            return;
        }
        this.rollingAverage.add(BigDecimal.valueOf(summary.median()));
    }

    @Override
    public void start(MinecraftServer server) {
        if (this.future != null) {
            throw new IllegalStateException();
        }
        this.server = server;
        this.future = MonitoringExecutor.INSTANCE.scheduleAtFixedRate(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.server = null;
    }

    @Override
    public PingSummary currentSummary() {
        int[] values = this.server.func_184103_al().func_181057_v().stream().mapToInt(p -> p.field_71138_i).filter(i -> i > 0).toArray();
        return values.length == 0 ? PingSummary.EMPTY : new PingSummary(values);
    }

    @Override
    public RollingAverage average() {
        return this.rollingAverage;
    }

    @Override
    public PlayerPing playerPing(String playerName) {
        EntityPlayerMP player = this.server.func_184103_al().func_152612_a(playerName);
        if (player != null) {
            return new PlayerPing(playerName, player.field_71138_i);
        }
        List players = this.server.func_184103_al().func_181057_v();
        for (int i = 0; i < players.size(); ++i) {
            player = (EntityPlayerMP)players.get(i);
            if (!player.func_70005_c_().equalsIgnoreCase(playerName)) continue;
            return new PlayerPing(player.func_70005_c_(), player.field_71138_i);
        }
        return null;
    }

    @Override
    public PlayerPing playerPing(UUID playerUuid) {
        EntityPlayerMP player = this.server.func_184103_al().func_177451_a(playerUuid);
        if (player != null) {
            return new PlayerPing(player.func_70005_c_(), player.field_71138_i);
        }
        return null;
    }
}

