/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.os;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum LinuxProc {
    CPUINFO("/proc/cpuinfo"),
    MEMINFO("/proc/meminfo"),
    NET_DEV("/proc/net/dev"),
    OSINFO("/etc/os-release");

    private final Path path;

    private LinuxProc(String path) {
        this.path = LinuxProc.resolvePath(path);
    }

    @Nullable
    private static Path resolvePath(String path) {
        try {
            Path p = Paths.get(path, new String[0]);
            if (Files.isReadable(p)) {
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nonnull
    public List<String> read() {
        if (this.path != null) {
            try {
                return Files.readAllLines(this.path, StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

