/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.memory;

import com.cleanroommc.flare.common.component.os.LinuxProc;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class MemoryInfo {
    private static final String OPERATING_SYSTEM_BEAN = "java.lang:type=OperatingSystem";
    private static final OperatingSystemMXBean BEAN;
    private static final Pattern PROC_MEMINFO_VALUE;

    public static long getUsedSwap() {
        return BEAN.getTotalSwapSpaceSize() - BEAN.getFreeSwapSpaceSize();
    }

    public static long getTotalSwap() {
        return BEAN.getTotalSwapSpaceSize();
    }

    public static long getUsedPhysicalMemory() {
        return MemoryInfo.getTotalPhysicalMemory() - MemoryInfo.getAvailablePhysicalMemory();
    }

    public static long getTotalPhysicalMemory() {
        for (String line : LinuxProc.MEMINFO.read()) {
            Matcher matcher = PROC_MEMINFO_VALUE.matcher(line);
            if (!matcher.matches()) continue;
            String label = matcher.group(1);
            long value = Long.parseLong(matcher.group(2)) * 1024L;
            if (!label.equals("MemTotal")) continue;
            return value;
        }
        return BEAN.getTotalPhysicalMemorySize();
    }

    public static long getAvailablePhysicalMemory() {
        boolean present = false;
        long free = 0L;
        long buffers = 0L;
        long cached = 0L;
        long sReclaimable = 0L;
        for (String line : LinuxProc.MEMINFO.read()) {
            Matcher matcher = PROC_MEMINFO_VALUE.matcher(line);
            if (!matcher.matches()) continue;
            present = true;
            String label = matcher.group(1);
            long value = Long.parseLong(matcher.group(2)) * 1024L;
            if (label.equals("MemAvailable")) {
                return value;
            }
            switch (label) {
                case "MemFree": {
                    free = value;
                    break;
                }
                case "Buffers": {
                    buffers = value;
                    break;
                }
                case "Cached": {
                    cached = value;
                    break;
                }
                case "SReclaimable": {
                    sReclaimable = value;
                }
            }
        }
        if (present) {
            return free + buffers + cached + sReclaimable;
        }
        return BEAN.getFreePhysicalMemorySize();
    }

    public static long getTotalVirtualMemory() {
        return BEAN.getCommittedVirtualMemorySize();
    }

    private MemoryInfo() {
    }

    static {
        PROC_MEMINFO_VALUE = Pattern.compile("^(\\w+):\\s*(\\d+) kB$");
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName diagnosticBeanName = ObjectName.getInstance(OPERATING_SYSTEM_BEAN);
            BEAN = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, OperatingSystemMXBean.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("OperatingSystemMXBean is not supported by the system", e);
        }
    }

    public static interface OperatingSystemMXBean {
        public long getCommittedVirtualMemorySize();

        public long getTotalSwapSpaceSize();

        public long getFreeSwapSpaceSize();

        public long getFreePhysicalMemorySize();

        public long getTotalPhysicalMemorySize();
    }
}

