/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.memory.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.component.memory.heap.dump.HeapDumpSummary;
import com.cleanroommc.flare.proto.FlareHeapProtos;
import com.cleanroommc.flare.util.LangKeys;
import com.cleanroommc.flare.util.ProtoUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;

public class HeapSummaryCommand
extends FlareSubCommand {
    public HeapSummaryCommand(FlareAPI flare) {
        super(flare);
    }

    public String func_71517_b() {
        return "summary";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare heap summary [--save-locally], [--run-gc-first]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        HeapDumpSummary heapDump;
        if (this.hasArg(args, "run-gc-first")) {
            System.gc();
        }
        this.sendMessage(sender, LangKeys.HEAP_SUMMARY_WAIT, new Object[0]);
        try {
            heapDump = HeapDumpSummary.createNew();
        }
        catch (Exception e) {
            this.sendMessage(sender, LangKeys.INSPECTING_HEAP_UNEXPECTED_EXCEPTION, new Object[0]);
            e.printStackTrace();
            return;
        }
        FlareHeapProtos.HeapData heapData = ProtoUtil.getHeapDataProto(this.flare, sender, heapDump);
        boolean saveLocally = this.hasArg(args, "save-locally");
        if (!saveLocally) {
            try {
                String key = this.flare.bytebinClient().postContent("application/x-spark-heap", heapData);
                String url = this.flare.viewerUrl() + key;
                this.sendMessage(sender, LangKeys.HEAP_SUMMARY_REPORT, (TextComponentTranslation text) -> text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url)), url);
            }
            catch (Throwable t) {
                this.sendMessage(sender, LangKeys.CANNOT_UPLOAD_SAVE_TO_DISK_INSTEAD, new Object[0]);
                this.flare.logger().fatal((Object)t);
                saveLocally = true;
            }
        }
        if (saveLocally) {
            try {
                Path heapSummaryDir = this.flare.saveDirectory().resolve("heap").resolve("summary");
                Files.createDirectories(heapSummaryDir, new FileAttribute[0]);
                Path heapSummaryFile = heapSummaryDir.resolve(new SimpleDateFormat("yyyy-MM-dd-hh_mm'.sparkheap'").format(new Date()));
                Files.write(heapSummaryFile, heapData.toByteArray(), new OpenOption[0]);
                this.sendMessage(sender, LangKeys.HEAP_SUMMARY_REPORT, (TextComponentTranslation text) -> text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, heapSummaryFile.toFile().getAbsolutePath())), heapSummaryFile.getFileName());
                this.sendMessage(sender, LangKeys.HEAP_SUMMARY_REPORT_USAGE_HINT, this.flare.viewerUrl());
            }
            catch (IOException e) {
                this.sendMessage(sender, LangKeys.CANNOT_SAVE_TO_DISK, new Object[0]);
                e.printStackTrace();
            }
        }
    }
}

