/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.thread;

import com.cleanroommc.flare.util.ThreadFinder;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface ThreadDumper {
    public static final ThreadDumper ALL = new ThreadDumper(){

        @Override
        public ThreadInfo[] dump(ThreadMXBean threadBean) {
            return threadBean.dumpAllThreads(false, false);
        }

        @Override
        public boolean threadIncluded(long threadId, String threadName) {
            return true;
        }
    };

    public ThreadInfo[] dump(ThreadMXBean var1);

    public boolean threadIncluded(long var1, String var3);

    public static final class Regex
    implements ThreadDumper {
        private final ThreadFinder threadFinder = new ThreadFinder();
        private final Set<Pattern> namePatterns;
        private final Long2BooleanMap cache = new Long2BooleanOpenHashMap();

        public Regex(Set<String> namePatterns) {
            this.namePatterns = namePatterns.stream().map(regex -> Pattern.compile(regex, 2)).collect(Collectors.toSet());
        }

        public Set<Pattern> namePatterns() {
            return this.namePatterns;
        }

        @Override
        public boolean threadIncluded(long threadId, String threadName) {
            if (this.cache.containsKey(threadId)) {
                return this.cache.get(threadId);
            }
            for (Pattern pattern : this.namePatterns) {
                if (!pattern.matcher(threadName).matches()) continue;
                this.cache.put(threadId, true);
                return true;
            }
            this.cache.put(threadId, false);
            return false;
        }

        @Override
        public ThreadInfo[] dump(ThreadMXBean threadBean) {
            return (ThreadInfo[])this.threadFinder.getThreads().filter(thread -> this.threadIncluded(thread.getId(), thread.getName())).map(thread -> threadBean.getThreadInfo(thread.getId(), Integer.MAX_VALUE)).filter(Objects::nonNull).toArray(ThreadInfo[]::new);
        }
    }

    public static final class Specific
    implements ThreadDumper {
        private final long[] ids;
        private Set<Thread> threads;
        private Set<String> threadNamesLowerCase;

        public Specific(Thread thread) {
            this.ids = new long[]{thread.getId()};
        }

        public Specific(Set<String> names) {
            this.threadNamesLowerCase = names.stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.ids = new ThreadFinder().getThreads().filter(t -> this.threadNamesLowerCase.contains(t.getName().toLowerCase())).mapToLong(Thread::getId).toArray();
            Arrays.sort(this.ids);
        }

        public Set<Thread> threads() {
            if (this.threads == null) {
                this.threads = new ThreadFinder().getThreads().filter(t -> Arrays.binarySearch(this.ids, t.getId()) >= 0).collect(Collectors.toSet());
            }
            return this.threads;
        }

        public LongList threadIds() {
            return new LongArrayList(this.ids);
        }

        public Set<String> threadNames() {
            if (this.threadNamesLowerCase == null) {
                this.threadNamesLowerCase = this.threads().stream().map(t -> t.getName().toLowerCase()).collect(Collectors.toSet());
            }
            return this.threadNamesLowerCase;
        }

        @Override
        public boolean threadIncluded(long threadId, String threadName) {
            if (Arrays.binarySearch(this.ids, threadId) >= 0) {
                return true;
            }
            return this.threadNames().contains(threadName.toLowerCase());
        }

        @Override
        public ThreadInfo[] dump(ThreadMXBean threadBean) {
            return threadBean.getThreadInfo(this.ids, Integer.MAX_VALUE);
        }
    }

    public static final class GameThread
    implements Supplier<ThreadDumper> {
        private Supplier<Thread> threadSupplier;
        private Specific dumper = null;

        public GameThread() {
        }

        public GameThread(Supplier<Thread> threadSupplier) {
            this.threadSupplier = threadSupplier;
        }

        @Override
        public ThreadDumper get() {
            if (this.dumper == null) {
                this.setThread(this.threadSupplier.get());
                this.threadSupplier = null;
            }
            return Objects.requireNonNull(this.dumper, "dumper");
        }

        public void setThread(Thread thread) {
            this.dumper = new Specific(thread);
        }
    }
}

