/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.node.type;

import com.cleanroommc.flare.api.sampler.node.MergeMode;
import com.cleanroommc.flare.api.sampler.node.MethodDescriptorResolver;
import com.cleanroommc.flare.api.sampler.node.description.NodeDescriber;
import com.cleanroommc.flare.api.sampler.node.description.NodeDescription;
import com.cleanroommc.flare.api.sampler.node.type.SamplingStackNode;
import com.cleanroommc.flare.api.sampler.node.type.StackTraceNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;

public class ThreadNode
extends SamplingStackNode {
    private final String name;
    private String label;

    public ThreadNode(String name) {
        this.name = name;
    }

    @Override
    protected SamplingStackNode resolveChild(NodeDescription description) {
        return this.children.computeIfAbsent(description, StackTraceNode::new);
    }

    public String label() {
        return this.label != null ? this.label : this.name;
    }

    public String group() {
        return this.name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public <T> void trace(NodeDescriber<T> describer, T[] stack, long time, int window) {
        if (stack.length == 0) {
            return;
        }
        this.timeAccumulator(window).add(time);
        SamplingStackNode node = this;
        Object previous = null;
        for (int offset = 0; offset < Math.min(ThreadNode.maxStackDepth(), stack.length); ++offset) {
            T current = stack[stack.length - 1 - offset];
            node = node.resolveChild(describer.describe(current, previous));
            node.timeAccumulator(window).add(time);
            previous = current;
        }
    }

    public boolean removeTimeWindowsRecursively(IntPredicate predicate) {
        ArrayDeque<SamplingStackNode> queue = new ArrayDeque<SamplingStackNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            SamplingStackNode node = (SamplingStackNode)queue.remove();
            Collection<SamplingStackNode> children = node.children();
            boolean needToProcessChildren = false;
            Iterator<SamplingStackNode> it = children.iterator();
            while (it.hasNext()) {
                SamplingStackNode child = it.next();
                boolean windowsWereRemoved = child.removeTimeWindows(predicate);
                if (child.timeWindows().isEmpty()) {
                    it.remove();
                    continue;
                }
                if (!windowsWereRemoved) continue;
                needToProcessChildren = true;
            }
            if (!needToProcessChildren) continue;
            queue.addAll(children);
        }
        this.removeTimeWindows(predicate);
        return this.timeWindows().isEmpty();
    }

    public List<StackTraceNode> exportChildren(MethodDescriptorResolver resolver, boolean separateParentCalls) {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(this.children.size());
        block0: for (SamplingStackNode child : this.children.values()) {
            if (!(child instanceof StackTraceNode)) continue;
            StackTraceNode stackTraceChildNode = (StackTraceNode)child;
            for (StackTraceNode other : list) {
                if (!MergeMode.shouldMerge(resolver, separateParentCalls, other, stackTraceChildNode)) continue;
                other.merge(child);
                continue block0;
            }
            list.add(stackTraceChildNode);
        }
        return list;
    }
}

