/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.gravitygun.common.gravitygun;

import java.util.ArrayList;
import java.util.HashSet;
import me.ichun.mods.gravitygun.common.GravityGun;
import me.ichun.mods.gravitygun.common.core.SoundIndex;
import me.ichun.mods.gravitygun.common.gravitygun.GravityGunGrabHandler;
import me.ichun.mods.gravitygun.common.gravitygun.KeyInfo;
import me.ichun.mods.gravitygun.common.item.ItemGravityGun;
import me.ichun.mods.gravitygun.common.packet.PacketGrabEvent;
import me.ichun.mods.gravitygun.common.packet.PacketThrowEffect;
import me.ichun.mods.gravitygun.common.packet.PacketThrowEntity;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.entity.EntityBlock;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class GravityGunHelper {
    public static boolean tryGrab(EntityLivingBase living, int chargeTime) {
        KeyInfo info;
        int damage = 2;
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)living);
        if (is.func_190926_b()) {
            return false;
        }
        damage = is.func_77952_i();
        if (GrabHandler.hasHandlerType((EntityLivingBase)living, (Side)Side.SERVER, GravityGunGrabHandler.class)) {
            GravityGunGrabHandler handler = (GravityGunGrabHandler)GrabHandler.release((EntityLivingBase)living, (Side)Side.SERVER, GravityGunGrabHandler.class);
            EntityHelper.playSoundAtEntity((Entity)living, (SoundEvent)SoundIndex.ggDrop, (SoundCategory)living.func_184176_by(), (float)0.2f, (float)ItemGravityGun.getItemPitch(ItemHandler.getUsableDualHandedItem((EntityLivingBase)living)));
            if (handler.grabbed instanceof EntityBlock) {
                EntityBlock block = (EntityBlock)handler.grabbed;
                block.setRotFacYaw(0.0f);
                block.setRotFacPitch(0.0f);
                block.setCanRotate(false);
            }
            GravityGun.channel.sendToAll((AbstractPacket)new PacketGrabEvent(handler.identifier, handler.grabberId, handler.grabbedId, handler.grabDistance, false));
            return true;
        }
        if (GravityGunHelper.canGrab(living, chargeTime)) {
            RayTraceResult mop = EntityHelper.getEntityLook((Entity)living, (double)(5.0 * (damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorGrabDistance / 100.0)));
            Entity grabbedEnt = null;
            if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
                grabbedEnt = mop.field_72308_g;
            } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                HashSet<BlockPos> blockPoses = new HashSet<BlockPos>();
                float radius = MathHelper.func_76131_a((float)((float)chargeTime / 55.0f), (float)0.0f, (float)5.0f);
                float radiusX = mop.field_178784_b.func_176740_k() == EnumFacing.Axis.X ? MathHelper.func_76131_a((float)(radius * 2.0f - 0.25f), (float)0.0f, (float)100.0f) : radius;
                float radiusY = mop.field_178784_b.func_176740_k() == EnumFacing.Axis.Y ? MathHelper.func_76131_a((float)(radius * 2.0f - 0.25f), (float)0.0f, (float)100.0f) : radius;
                float radiusZ = mop.field_178784_b.func_176740_k() == EnumFacing.Axis.Z ? MathHelper.func_76131_a((float)(radius * 2.0f - 0.25f), (float)0.0f, (float)100.0f) : radius;
                for (double x = mop.field_72307_f.field_72450_a - (double)radiusX; x <= mop.field_72307_f.field_72450_a + (double)radiusX + 0.5; x += 1.0) {
                    for (double y = mop.field_72307_f.field_72448_b - (double)radiusY; y <= mop.field_72307_f.field_72448_b + (double)radiusY + 0.5; y += 1.0) {
                        for (double z = mop.field_72307_f.field_72449_c - (double)radiusZ; z <= mop.field_72307_f.field_72449_c + (double)radiusZ + 0.5; z += 1.0) {
                            BlockPos offset = mop.func_178782_a();
                            if (mop.field_178784_b.func_176745_a() % 2 == 1) {
                                offset = mop.func_178782_a().func_177967_a(mop.field_178784_b, -1);
                            }
                            Vec3d temp = new Vec3d(mop.field_72307_f.field_72450_a + (double)(offset.func_177958_n() - mop.func_178782_a().func_177958_n()), mop.field_72307_f.field_72448_b + (double)(offset.func_177956_o() - mop.func_178782_a().func_177956_o()), mop.field_72307_f.field_72449_c + (double)(offset.func_177952_p() - mop.func_178782_a().func_177952_p()));
                            BlockPos pos = new BlockPos(temp.func_72441_c(x - mop.field_72307_f.field_72450_a, y - mop.field_72307_f.field_72448_b, z - mop.field_72307_f.field_72449_c));
                            if (mop.field_178784_b == EnumFacing.WEST && pos.func_177958_n() < mop.func_178782_a().func_177958_n() || mop.field_178784_b == EnumFacing.EAST && pos.func_177958_n() > mop.func_178782_a().func_177958_n() || mop.field_178784_b == EnumFacing.DOWN && pos.func_177956_o() < mop.func_178782_a().func_177956_o() || mop.field_178784_b == EnumFacing.UP && pos.func_177956_o() > mop.func_178782_a().func_177956_o() || mop.field_178784_b == EnumFacing.NORTH && pos.func_177952_p() < mop.func_178782_a().func_177952_p() || mop.field_178784_b == EnumFacing.SOUTH && pos.func_177952_p() > mop.func_178782_a().func_177952_p()) continue;
                            IBlockState state = living.field_70170_p.func_180495_p(pos);
                            Block block = state.func_177230_c();
                            if (state.func_185887_b(living.field_70170_p, pos) < 0.0f || block.isAir(state, (IBlockAccess)living.field_70170_p, pos) || block.hasTileEntity(state) && damage < GravityGun.config.capabilitiesGrabTileEntity || !block.isNormalCube(state, (IBlockAccess)living.field_70170_p, pos) && !GravityGunHelper.isAcceptableBlockType(state, block)) continue;
                            blockPoses.add(pos);
                        }
                    }
                }
                if (!blockPoses.isEmpty()) {
                    double d = Math.pow((double)blockPoses.size() * 0.95, 0.3333333333333333);
                    double d2 = (double)GravityGun.config.entityGrabMaxWeight / 100.0;
                    double d3 = damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorGrab / 100.0;
                    if (d < d2 * d3) {
                        boolean canGrab = GravityGun.config.whitelistBlocks == 0;
                        for (BlockPos pos : blockPoses) {
                            IBlockState state = living.field_70170_p.func_180495_p(pos);
                            ResourceLocation loc = state.func_177230_c().getRegistryName();
                            if (loc == null) continue;
                            for (String s : GravityGun.config.blacklistBlocks) {
                                if (!s.equals(loc.toString())) continue;
                                canGrab = GravityGun.config.whitelistBlocks != 0;
                                break;
                            }
                            if (canGrab == (GravityGun.config.whitelistBlocks == 0)) continue;
                            break;
                        }
                        if (canGrab && (grabbedEnt = EntityBlock.createEntityBlock((World)living.field_70170_p, (EntityLivingBase)living, blockPoses)) != null) {
                            living.field_70170_p.func_72838_d(grabbedEnt);
                        }
                    }
                }
            }
            if (grabbedEnt != null) {
                ArrayList handlers = (ArrayList)GrabHandler.grabbedEntities.get(Side.SERVER);
                for (GrabHandler handler : handlers) {
                    if (handler.grabbed != grabbedEnt) continue;
                    if (handler instanceof GravityGunGrabHandler) {
                        GravityGunHelper.tryGrab(handler.grabber, 0);
                        break;
                    }
                    handler.terminate();
                    handlers.remove(handler);
                    break;
                }
                float dist = 3.5f;
                float width = grabbedEnt.field_70130_N;
                if ((double)width > 2.0) {
                    dist = MathHelper.func_76131_a((float)(dist + width - 2.0f), (float)3.5f, (float)6.0f);
                }
                GravityGunGrabHandler handler = new GravityGunGrabHandler(living, grabbedEnt, dist);
                GrabHandler.grab((GrabHandler)handler, (Side)Side.SERVER);
                EntityHelper.playSoundAtEntity((Entity)living, (SoundEvent)SoundIndex.ggPickup, (SoundCategory)living.func_184176_by(), (float)0.2f, (float)ItemGravityGun.getItemPitch(ItemHandler.getUsableDualHandedItem((EntityLivingBase)living)));
                GravityGun.channel.sendToAll((AbstractPacket)new PacketGrabEvent(handler.identifier, handler.grabberId, handler.grabbedId, handler.grabDistance, true));
                return true;
            }
        } else if (!GravityGunHelper.canPull(living) && ((info = GravityGun.eventHandlerServer.playerKeyInfo.get(living.func_70005_c_())) == null || !info.triggeredSound && info.pulledEntity == null)) {
            if (info != null) {
                info.triggeredSound = true;
            }
            EntityHelper.playSoundAtEntity((Entity)living, (SoundEvent)SoundIndex.ggTooHeavy, (SoundCategory)living.func_184176_by(), (float)0.2f, (float)1.0f);
        }
        return false;
    }

    public static boolean canGrab(EntityLivingBase living, int chargeTime) {
        int damage = 2;
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)living);
        if (is.func_190926_b()) {
            return false;
        }
        damage = is.func_77952_i();
        RayTraceResult mop = EntityHelper.getEntityLook((Entity)living, (double)(5.0 * (damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorGrabDistance / 100.0)));
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY && damage >= GravityGun.config.capabilitiesGrabEntity && mop.field_72308_g != living.func_184187_bx()) {
            double d = Math.pow(mop.field_72308_g.field_70130_N * mop.field_72308_g.field_70130_N * mop.field_72308_g.field_70131_O, 0.3333333333333333);
            double d2 = (double)GravityGun.config.entityGrabMaxWeight / 100.0;
            double d3 = damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorGrab / 100.0;
            if (d < d2 * d3) {
                if (!mop.field_72308_g.func_184222_aU()) {
                    return damage >= GravityGun.config.capabilitiesGrabBosses;
                }
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    ArrayList handlers = GrabHandler.getHandlers((EntityLivingBase)((EntityLivingBase)mop.field_72308_g), (Side)Side.SERVER);
                    for (GrabHandler handler : handlers) {
                        if (handler.grabbed != living) continue;
                        return false;
                    }
                }
                return !(mop.field_72308_g instanceof EntityPlayer) || damage >= GravityGun.config.capabilitiesGrabPlayer;
            }
        }
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK && damage >= GravityGun.config.capabilitiesGrabBlock) {
            boolean hasPickupable = false;
            float radius = MathHelper.func_76131_a((float)((float)chargeTime / 55.0f), (float)0.0f, (float)5.0f);
            float radiusX = mop.field_178784_b.func_176740_k() == EnumFacing.Axis.X ? MathHelper.func_76131_a((float)(radius * 2.0f - 0.25f), (float)0.0f, (float)100.0f) : radius;
            float radiusY = mop.field_178784_b.func_176740_k() == EnumFacing.Axis.Y ? MathHelper.func_76131_a((float)(radius * 2.0f - 0.25f), (float)0.0f, (float)100.0f) : radius;
            float radiusZ = mop.field_178784_b.func_176740_k() == EnumFacing.Axis.Z ? MathHelper.func_76131_a((float)(radius * 2.0f - 0.25f), (float)0.0f, (float)100.0f) : radius;
            for (double x = mop.field_72307_f.field_72450_a - (double)radiusX; x <= mop.field_72307_f.field_72450_a + (double)radiusX + 0.5; x += 1.0) {
                for (double y = mop.field_72307_f.field_72448_b - (double)radiusY; y <= mop.field_72307_f.field_72448_b + (double)radiusY + 0.5; y += 1.0) {
                    for (double z = mop.field_72307_f.field_72449_c - (double)radiusZ; z <= mop.field_72307_f.field_72449_c + (double)radiusZ + 0.5; z += 1.0) {
                        IBlockState state;
                        Block block;
                        BlockPos offset = mop.func_178782_a();
                        if (mop.field_178784_b.func_176745_a() % 2 == 1) {
                            offset = mop.func_178782_a().func_177967_a(mop.field_178784_b, -1);
                        }
                        Vec3d temp = new Vec3d(mop.field_72307_f.field_72450_a + (double)(offset.func_177958_n() - mop.func_178782_a().func_177958_n()), mop.field_72307_f.field_72448_b + (double)(offset.func_177956_o() - mop.func_178782_a().func_177956_o()), mop.field_72307_f.field_72449_c + (double)(offset.func_177952_p() - mop.func_178782_a().func_177952_p()));
                        BlockPos pos = new BlockPos(temp.func_72441_c(x - mop.field_72307_f.field_72450_a, y - mop.field_72307_f.field_72448_b, z - mop.field_72307_f.field_72449_c));
                        if (mop.field_178784_b == EnumFacing.WEST && pos.func_177958_n() < mop.func_178782_a().func_177958_n() || mop.field_178784_b == EnumFacing.EAST && pos.func_177958_n() > mop.func_178782_a().func_177958_n() || mop.field_178784_b == EnumFacing.DOWN && pos.func_177956_o() < mop.func_178782_a().func_177956_o() || mop.field_178784_b == EnumFacing.UP && pos.func_177956_o() > mop.func_178782_a().func_177956_o() || mop.field_178784_b == EnumFacing.NORTH && pos.func_177952_p() < mop.func_178782_a().func_177952_p() || mop.field_178784_b == EnumFacing.SOUTH && pos.func_177952_p() > mop.func_178782_a().func_177952_p() || (block = (state = living.field_70170_p.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)living.field_70170_p, pos)) continue;
                        if (state.func_185887_b(living.field_70170_p, pos) < 0.0f) {
                            return false;
                        }
                        if (block.hasTileEntity(state) && damage < GravityGun.config.capabilitiesGrabTileEntity || !block.isNormalCube(state, (IBlockAccess)living.field_70170_p, pos) && !GravityGunHelper.isAcceptableBlockType(state, block)) {
                            return false;
                        }
                        hasPickupable = true;
                    }
                }
            }
            return hasPickupable;
        }
        return false;
    }

    public static boolean tryPull(EntityLivingBase living, KeyInfo info) {
        if (!(info != null && info.chargeTime > 0 || GravityGunHelper.tryGrab(living, 0))) {
            if (GravityGunHelper.canPull(living) || info != null && info.pulledEntity != null) {
                Entity entityToPull;
                int damage = 2;
                ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)living);
                if (is.func_190926_b()) {
                    return true;
                }
                damage = is.func_77952_i();
                double dist = (double)GravityGun.config.pullDistance * (damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorPull / 100.0);
                RayTraceResult mop = EntityHelper.getEntityLook((Entity)living, (double)dist);
                Entity entity = entityToPull = info == null ? null : info.pulledEntity;
                if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
                    if (info != null && (info.pulledEntity == null || info.pulledEntity == mop.field_72308_g)) {
                        info.pulledEntity = mop.field_72308_g;
                        info.pullTime = 10;
                    }
                    if (entityToPull == null) {
                        entityToPull = mop.field_72308_g;
                    }
                } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK && entityToPull == null) {
                    HashSet<BlockPos> blockPoses = new HashSet<BlockPos>();
                    blockPoses.add(mop.func_178782_a());
                    boolean canGrab = GravityGun.config.whitelistBlocks == 0;
                    IBlockState state = living.field_70170_p.func_180495_p(mop.func_178782_a());
                    ResourceLocation loc = state.func_177230_c().getRegistryName();
                    if (loc != null) {
                        for (String s : GravityGun.config.blacklistBlocks) {
                            if (!s.equals(loc.toString())) continue;
                            canGrab = GravityGun.config.whitelistBlocks != 0;
                            break;
                        }
                    }
                    if (canGrab && (entityToPull = EntityBlock.createEntityBlock((World)living.field_70170_p, (EntityLivingBase)living, blockPoses)) != null) {
                        living.field_70170_p.func_72838_d(entityToPull);
                        if (info != null) {
                            info.pulledEntity = entityToPull;
                            info.pullTime = 10;
                        }
                    }
                }
                if (entityToPull != null) {
                    Vec3d look = living.func_70040_Z();
                    double distance = entityToPull.func_70032_d((Entity)living);
                    double distX = living.field_70165_t + look.field_72450_a * 2.5 - entityToPull.field_70165_t;
                    double distY = living.field_70163_u + (double)living.func_70047_e() + look.field_72448_b * 2.5 - (entityToPull.func_174813_aQ().field_72338_b + entityToPull.func_174813_aQ().field_72337_e) / 2.0;
                    double distZ = living.field_70161_v + look.field_72449_c * 2.5 - entityToPull.field_70161_v;
                    double mX = (distX > 0.0 ? 1.0 : -1.0) * (distX * distX) / (distance * distance);
                    double mY = (distY > 0.0 ? 2.0 : -0.8) * (distY * distY) / (distance * distance);
                    double mZ = (distZ > 0.0 ? 1.0 : -1.0) * (distZ * distZ) / (distance * distance);
                    double mag = MathHelper.func_151237_a((double)((dist - distance) / dist), (double)0.3, (double)1.0) * 1.5;
                    entityToPull.func_70024_g(mX * mag, mY * mag, mZ * mag);
                    if (entityToPull instanceof EntityPlayerMP) {
                        EntityPlayerMP player1 = (EntityPlayerMP)entityToPull;
                        player1.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player1.func_145782_y(), player1.field_70159_w, player1.field_70181_x, player1.field_70179_y));
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean canPull(EntityLivingBase living) {
        int damage = 2;
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)living);
        if (is.func_190926_b()) {
            return false;
        }
        damage = is.func_77952_i();
        double dist = (double)GravityGun.config.pullDistance * (damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorPull / 100.0);
        RayTraceResult mop = EntityHelper.getEntityLook((Entity)living, (double)dist);
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY && damage >= GravityGun.config.capabilitiesPullEntity) {
            if (!mop.field_72308_g.func_184222_aU()) {
                return damage >= GravityGun.config.capabilitiesPullBosses;
            }
            return !(mop.field_72308_g instanceof EntityPlayer) || damage >= GravityGun.config.capabilitiesPullPlayer;
        }
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK && damage >= GravityGun.config.capabilitiesPullBlock) {
            IBlockState state = living.field_70170_p.func_180495_p(mop.func_178782_a());
            Block block = state.func_177230_c();
            if (state.func_185887_b(living.field_70170_p, mop.func_178782_a()) >= 0.0f && (block.isNormalCube(state, (IBlockAccess)living.field_70170_p, mop.func_178782_a()) || GravityGunHelper.isAcceptableBlockType(state, block))) {
                return !block.hasTileEntity(state) || damage >= GravityGun.config.capabilitiesPullTileEntity;
            }
        }
        return false;
    }

    public static boolean tryPush(EntityLivingBase living) {
        int damage = 2;
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)living);
        if (is.func_190926_b()) {
            return false;
        }
        damage = is.func_77952_i();
        Entity entityToPush = null;
        if (GrabHandler.hasHandlerType((EntityLivingBase)living, (Side)Side.SERVER, GravityGunGrabHandler.class)) {
            entityToPush = GrabHandler.getFirstHandler((EntityLivingBase)living, (Side)Side.SERVER, GravityGunGrabHandler.class).grabbed;
        } else {
            RayTraceResult mop = EntityHelper.getEntityLook((Entity)living, (double)5.0);
            if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
                entityToPush = mop.field_72308_g;
            }
        }
        if (entityToPush != null && damage >= GravityGun.config.capabilitiesPushEntity) {
            if (GrabHandler.hasHandlerType((EntityLivingBase)living, (Side)Side.SERVER, GravityGunGrabHandler.class)) {
                GravityGunGrabHandler handler = (GravityGunGrabHandler)GrabHandler.release((EntityLivingBase)living, (Side)Side.SERVER, GravityGunGrabHandler.class);
                GravityGun.channel.sendToAll((AbstractPacket)new PacketGrabEvent(handler.identifier, handler.grabberId, handler.grabbedId, handler.grabDistance, false));
            }
            Vec3d look = living.func_70040_Z();
            double dist = entityToPush.func_70032_d((Entity)living);
            if (dist < 3.0) {
                dist = 3.0;
            }
            double amp = (double)GravityGun.config.pushFactor * (damage == 0 ? 1.0 : (double)GravityGun.config.superchargedAmplifyFactorPush / 100.0) / dist * 1.25;
            entityToPush.func_70024_g(look.field_72450_a * amp * 1.1, look.field_72448_b * amp, look.field_72449_c * amp * 1.1);
            if (entityToPush instanceof EntityPlayerMP) {
                EntityPlayerMP player1 = (EntityPlayerMP)entityToPush;
                player1.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player1.func_145782_y(), player1.field_70159_w, player1.field_70181_x, player1.field_70179_y));
            } else if (entityToPush instanceof EntityFireball) {
                EntityFireball fireball = (EntityFireball)entityToPush;
                fireball.field_70232_b = fireball.field_70159_w / 8.0;
                fireball.field_70233_c = fireball.field_70181_x / 8.0 - 0.03;
                fireball.field_70230_d = fireball.field_70179_y / 8.0;
            }
            if (!entityToPush.field_70132_H) {
                GravityGun.eventHandlerServer.addThrownEntity(entityToPush, living, entityToPush instanceof EntityCreeper && damage >= GravityGun.config.capabilityCreeperDetonation);
            }
            EntityHelper.playSoundAtEntity((Entity)living, (SoundEvent)SoundIndex.sggLaunch, (SoundCategory)living.func_184176_by(), (float)0.2f, (float)1.0f);
            if (living instanceof EntityPlayerMP) {
                GravityGun.channel.sendTo((AbstractPacket)new PacketThrowEntity(true), (EntityPlayer)((EntityPlayerMP)living));
            }
            GravityGun.channel.sendToAllAround((AbstractPacket)new PacketThrowEffect(living.func_145782_y(), (double)living.func_70032_d(entityToPush) - 0.5), new NetworkRegistry.TargetPoint(living.field_71093_bK, living.field_70165_t, living.field_70163_u, living.field_70161_v, 64.0));
        } else {
            EntityHelper.playSoundAtEntity((Entity)living, (SoundEvent)SoundIndex.ggDryFire, (SoundCategory)living.func_184176_by(), (float)0.2f, (float)1.0f);
            if (living instanceof EntityPlayerMP) {
                GravityGun.channel.sendTo((AbstractPacket)new PacketThrowEntity(false), (EntityPlayer)((EntityPlayerMP)living));
            }
        }
        return false;
    }

    public static boolean isAcceptableBlockType(IBlockState state, Block block) {
        return state.func_185901_i() == EnumBlockRenderType.ENTITYBLOCK_ANIMATED || state.func_185904_a() == Material.field_151592_s || block == Blocks.field_150426_aN || block == Blocks.field_150414_aQ || block == Blocks.field_150335_W || block == Blocks.field_150432_aD || block instanceof BlockSlab || block == Blocks.field_150467_bQ || block instanceof BlockStairs;
    }
}

