/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.gravitygun.common.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.ichun.mods.gravitygun.common.GravityGun;
import me.ichun.mods.gravitygun.common.core.SoundIndex;
import me.ichun.mods.gravitygun.common.gravitygun.GravityGunGrabHandler;
import me.ichun.mods.gravitygun.common.gravitygun.GravityGunHelper;
import me.ichun.mods.gravitygun.common.gravitygun.KeyInfo;
import me.ichun.mods.gravitygun.common.gravitygun.ThrownEntityInfo;
import me.ichun.mods.gravitygun.common.item.ItemGravityGun;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.entity.EntityBlock;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandlerServer {
    public ArrayList<ThrownEntityInfo> thrownEntities = new ArrayList();
    public HashMap<String, KeyInfo> playerKeyInfo = new HashMap();

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)event.getPlayer());
        if (is.func_77973_b() == GravityGun.itemGravityGun) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack is = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (is.func_77973_b() == GravityGun.itemGravityGun) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityZombie zombie;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityZombie && (zombie = (EntityZombie)event.getEntityLiving()).func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == GravityGun.itemGravityGun && zombie.func_70681_au().nextFloat() < 0.008f) {
            if (zombie.func_70681_au().nextFloat() < 0.6f) {
                GravityGunHelper.tryGrab((EntityLivingBase)zombie, 0);
            } else {
                GravityGunHelper.tryPush((EntityLivingBase)zombie);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)event.getEntity();
            if (living instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                if (!player.field_71075_bZ.field_75098_d) {
                    for (ItemStack stack : player.field_71071_by.field_70462_a) {
                        if (stack == null || stack.func_77973_b() != GravityGun.itemGravityGun) continue;
                        stack.func_77964_b(1);
                    }
                    player.field_71071_by.func_70296_d();
                }
            } else if (living.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == GravityGun.itemGravityGun) {
                living.func_184586_b(EnumHand.MAIN_HAND).func_77964_b(1);
            }
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            for (int ii = this.thrownEntities.size() - 1; ii >= 0; --ii) {
                ThrownEntityInfo info = this.thrownEntities.get(ii);
                if (GrabHandler.isGrabbed((Entity)info.thrownEntity, (Side)Side.SERVER)) {
                    this.thrownEntities.remove(ii);
                    continue;
                }
                Vec3d vec31 = new Vec3d(info.thrownEntity.field_70165_t, info.thrownEntity.field_70163_u, info.thrownEntity.field_70161_v);
                Vec3d vec3 = new Vec3d(info.thrownEntity.field_70165_t + info.thrownEntity.field_70159_w, info.thrownEntity.field_70163_u + info.thrownEntity.field_70181_x, info.thrownEntity.field_70161_v + info.thrownEntity.field_70179_y);
                RayTraceResult mop = info.thrownEntity.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
                vec31 = new Vec3d(info.thrownEntity.field_70165_t, info.thrownEntity.field_70163_u, info.thrownEntity.field_70161_v);
                vec3 = new Vec3d(info.thrownEntity.field_70165_t + info.thrownEntity.field_70159_w, info.thrownEntity.field_70163_u + info.thrownEntity.field_70181_x, info.thrownEntity.field_70161_v + info.thrownEntity.field_70179_y);
                if (mop != null) {
                    vec3 = new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                }
                Entity entity = null;
                List list = info.thrownEntity.field_70170_p.func_72839_b(info.thrownEntity, info.thrownEntity.func_174813_aQ().func_72321_a(info.thrownEntity.field_70159_w, info.thrownEntity.field_70181_x, info.thrownEntity.field_70179_y).func_186662_g(1.0));
                double d0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double d1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.func_70067_L()) continue;
                    float f1 = 0.3f;
                    AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_186662_g((double)f1);
                    RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(vec31, vec3);
                    if (movingobjectposition1 == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    mop = new RayTraceResult(entity);
                }
                if (mop != null && mop.field_72308_g != null && mop.field_72308_g instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)mop.field_72308_g;
                    if (entityplayer.field_71075_bZ.field_75102_a) {
                        mop = null;
                    }
                }
                if (mop != null && mop.field_72313_a != RayTraceResult.Type.MISS && mop.field_72308_g != null) {
                    double volumehit;
                    int dmg = (int)Math.floor(2.3 * info.mag);
                    double volume = Math.pow(info.thrownEntity.field_70131_O * info.thrownEntity.field_70130_N * info.thrownEntity.field_70130_N, 0.33333);
                    if ((dmg = (int)((double)dmg * (volume / (volumehit = Math.pow(mop.field_72308_g.field_70131_O * mop.field_72308_g.field_70130_N * mop.field_72308_g.field_70130_N, 0.33333)) / 0.925))) > 0) {
                        mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)info.thrownEntity, (Entity)info.thrower), (float)dmg);
                    }
                    if (info.thrownEntity instanceof EntityCreeper && info.explosive) {
                        ((EntityCreeper)info.thrownEntity).func_146077_cc();
                    }
                    if (info.thrownEntity instanceof EntityBlock) {
                        ((EntityBlock)info.thrownEntity).shatter();
                    }
                }
                if (info.thrownEntity.field_70132_H || info.thrownEntity.field_70128_L) {
                    int dmg;
                    if (info.thrownEntity instanceof EntityCreeper && info.explosive && !info.thrownEntity.field_70128_L) {
                        ((EntityCreeper)info.thrownEntity).func_146077_cc();
                    }
                    if (info.thrownEntity instanceof EntityBlock) {
                        ((EntityBlock)info.thrownEntity).shatter();
                    }
                    if ((dmg = (int)Math.floor(2.3 * info.mag)) > 0) {
                        info.thrownEntity.func_70097_a(DamageSource.func_76356_a((Entity)info.thrownEntity, (Entity)info.thrower), (float)dmg);
                    }
                    this.thrownEntities.remove(ii);
                    continue;
                }
                info.mag = Math.sqrt(info.thrownEntity.field_70159_w * info.thrownEntity.field_70159_w + info.thrownEntity.field_70181_x * info.thrownEntity.field_70181_x + info.thrownEntity.field_70179_y * info.thrownEntity.field_70179_y);
                if (!(info.thrownEntity.field_70181_x > -0.005)) continue;
                info.thrownEntity.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && this.playerKeyInfo.get(event.player.func_70005_c_()) != null) {
            KeyInfo info = this.playerKeyInfo.get(event.player.func_70005_c_());
            --info.pullTime;
            if (info.pullTime <= 0) {
                info.pulledEntity = null;
            }
            if (info.pressedKey1) {
                ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)event.player);
                if (!info.pressedKey0) {
                    if (GravityGunHelper.canPull((EntityLivingBase)event.player) || info.pulledEntity != null) {
                        if (GravityGunHelper.tryPull((EntityLivingBase)event.player, info)) {
                            this.setKeyInfo(event.player.func_70005_c_(), -1, 0);
                        }
                    } else if (!info.triggeredSound) {
                        info.triggeredSound = true;
                        EntityHelper.playSoundAtEntity((Entity)event.player, (SoundEvent)SoundIndex.ggTooHeavy, (SoundCategory)event.player.func_184176_by(), (float)0.2f, (float)1.0f);
                    }
                } else if (!GrabHandler.hasHandlerType((EntityLivingBase)event.player, (Side)Side.SERVER, GravityGunGrabHandler.class) && is != null && is.func_77973_b() == GravityGun.itemGravityGun && is.func_77952_i() > 0) {
                    ++info.chargeTime;
                    if (info.chargeTime == 1) {
                        EntityHelper.playSoundAtEntity((Entity)event.player, (SoundEvent)SoundIndex.ggCharge, (SoundCategory)event.player.func_184176_by(), (float)0.2f, (float)1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        this.playerKeyInfo.remove(event.player.func_70005_c_());
    }

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        GravityGun.itemGravityGun = ((Item)new ItemGravityGun().func_77664_n().setRegistryName(new ResourceLocation("gravitygun", "gravitygun"))).func_77655_b("gravitygun.gravitygun").func_77637_a(CreativeTabs.field_78040_i);
        event.getRegistry().register((IForgeRegistryEntry)GravityGun.itemGravityGun);
    }

    @SubscribeEvent
    public void onRegisterSoundEvent(RegistryEvent.Register<SoundEvent> event) {
        SoundIndex.init((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    public void setKeyInfo(String name, int k0, int k1) {
        KeyInfo key = this.playerKeyInfo.get(name);
        if (key == null) {
            key = new KeyInfo(k0 == 1, k1 == 1);
            this.playerKeyInfo.put(name, key);
        } else {
            if (k0 >= 0) {
                boolean bl = key.pressedKey0 = k0 == 1;
                if (key.pressedKey0) {
                    key.chargeTime = 0;
                }
            }
            if (k1 >= 0) {
                boolean bl = key.pressedKey1 = k1 == 1;
                if (!key.pressedKey1) {
                    key.triggeredSound = false;
                }
            }
        }
    }

    public void addThrownEntity(Entity entityToPush, EntityLivingBase living, boolean explosive) {
        for (int i = this.thrownEntities.size() - 1; i >= 0; --i) {
            ThrownEntityInfo info = this.thrownEntities.get(i);
            if (info.thrownEntity != entityToPush) continue;
            this.thrownEntities.remove(i);
        }
        this.thrownEntities.add(new ThrownEntityInfo(entityToPush, living, explosive));
    }
}

