/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.gui;

import java.util.function.Consumer;
import net.minecraft.util.math.Vec3d;

public class GuiFormatHelpers {
    private static final String LANG_KEY = "gui.icbmclassic:";
    private static final String LANG_ERROR = "gui.icbmclassic:error";
    private static final String ERROR_NULL = "gui.icbmclassic:error.null";
    private static final String ERROR_FORMAT_INT = "gui.icbmclassic:error.format.number.int";
    private static final String ERROR_FORMAT_FLOAT = "gui.icbmclassic:error.format.number.float";
    private static final String ERROR_FORMAT_V3D = "gui.icbmclassic:error.format.vector.3d";
    private static final String ERROR_FORMAT_V2D = "gui.icbmclassic:error.format.vector.2d";

    public static String parseVec3d(String inputText, Consumer<Vec3d> setter) {
        if (inputText != null) {
            String[] split = inputText.split(",");
            if (split.length == 3) {
                try {
                    double x = Double.parseDouble(split[0].trim());
                    double y = Double.parseDouble(split[1].trim());
                    double z = Double.parseDouble(split[2].trim());
                    setter.accept(new Vec3d(x, y, z));
                    return null;
                }
                catch (NumberFormatException e) {
                    return ERROR_FORMAT_V3D;
                }
            }
            return ERROR_FORMAT_V3D;
        }
        return ERROR_NULL;
    }

    public static String parseInt(String inputText, Consumer<Integer> setter) {
        if (inputText != null) {
            try {
                setter.accept(Integer.parseInt(inputText.trim()));
                return null;
            }
            catch (NumberFormatException e) {
                return ERROR_FORMAT_INT;
            }
        }
        return ERROR_NULL;
    }
}

