/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import icbm.classic.lib.transform.vector.Pos;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Quaternion
implements ITransform {
    double x = 1.0;
    double y = 0.0;
    double z = 0.0;
    double w = 0.0;

    public Quaternion() {
    }

    public Quaternion(Quaternion Quaternion2) {
        this.x = Quaternion2.x;
        this.y = Quaternion2.y;
        this.z = Quaternion2.z;
        this.w = Quaternion2.w;
    }

    public Quaternion(double angle, IPos3D axis) {
        this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
        this.w = d;
    }

    public Quaternion set(Quaternion q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
        return this;
    }

    public Quaternion set(double d, double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
        this.w = d;
        return this;
    }

    public Quaternion setAroundAxis(double ax, double ay, double az, double originalAngle) {
        double angle = originalAngle;
        double d4 = Math.sin(angle *= 0.5);
        return this.set(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public Quaternion setAroundAxis(IPos3D axis, double angle) {
        return this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion multiply(Quaternion quaternion) {
        double d = this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        double d1 = this.w * quaternion.x + this.x * quaternion.w - this.y * quaternion.z + this.z * quaternion.y;
        double d2 = this.w * quaternion.y + this.x * quaternion.z + this.y * quaternion.w - this.z * quaternion.x;
        double d3 = this.w * quaternion.z - this.x * quaternion.y + this.y * quaternion.x + this.z * quaternion.w;
        this.w = d;
        this.x = d1;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Quaternion rightMultiply(Quaternion quaternion) {
        double d = this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        double d1 = this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y;
        double d2 = this.w * quaternion.y - this.x * quaternion.z + this.y * quaternion.w + this.z * quaternion.x;
        double d3 = this.w * quaternion.z + this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.w;
        this.w = d;
        this.x = d1;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public Quaternion normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x *= d;
            this.y *= d;
            this.z *= d;
            this.w *= d;
        }
        return this;
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    @Override
    public Pos transform(IPos3D vector) {
        double d = -this.x * vector.x() - this.y * vector.y() - this.z * vector.z();
        double d1 = this.w * vector.x() + this.y * vector.z() - this.z * vector.y();
        double d2 = this.w * vector.y() - this.x * vector.z() + this.z * vector.x();
        double d3 = this.w * vector.z() + this.x * vector.y() - this.y * vector.x();
        return new Pos(d1 * this.w - d * this.x - d2 * this.z + d3 * this.y, d2 * this.w - d * this.y + d1 * this.z - d3 * this.x, d3 * this.w - d * this.z - d1 * this.y + d2 * this.x);
    }

    public String toString() {
        int precision = 4;
        return "Quaternion[" + BigDecimal.valueOf(this.w).setScale(precision, RoundingMode.HALF_UP) + ", " + BigDecimal.valueOf(this.x).setScale(precision, RoundingMode.HALF_UP) + ", " + BigDecimal.valueOf(this.y).setScale(precision, RoundingMode.HALF_UP) + ", " + BigDecimal.valueOf(this.z).setScale(precision, RoundingMode.HALF_UP) + "]";
    }
}

