/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import icbm.classic.lib.tracker.EventTrackerEntry;
import icbm.classic.lib.tracker.EventTrackerType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;

public class EventTrackerField<DATA> {
    private final ResourceLocation key;
    private final Type type;
    private int index;
    private EventTrackerType parent;
    private final Function<EventTrackerEntry, DATA> accessor;

    public EventTrackerField(ResourceLocation key, Type type, Function<EventTrackerEntry, DATA> accessor) {
        this.key = key;
        this.type = type;
        this.accessor = accessor;
    }

    public DATA get(EventTrackerEntry entry) {
        return Optional.ofNullable(this.accessor).map(f -> f.apply(entry)).orElse(null);
    }

    public EventTrackerField<DATA> copy() {
        return new EventTrackerField<DATA>(this.key, this.type, this.accessor);
    }

    @Generated
    public ResourceLocation getKey() {
        return this.key;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public EventTrackerType getParent() {
        return this.parent;
    }

    @Generated
    void setParent(EventTrackerType parent) {
        this.parent = parent;
    }
}

