/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.saving;

import icbm.classic.lib.saving.INbtSaveNode;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;

public class NbtSaveNode<SaveObject, NbtData extends NBTBase>
implements INbtSaveNode<SaveObject, NbtData> {
    private final String name;
    private final Function<SaveObject, NbtData> save;
    private final BiConsumer<SaveObject, NbtData> load;

    public NbtSaveNode(String name, Function<SaveObject, NbtData> save, BiConsumer<SaveObject, NbtData> load) {
        if (name == null) {
            throw new IllegalArgumentException("save key can't be null");
        }
        this.name = name;
        this.save = save;
        this.load = load;
    }

    @Override
    public String getSaveKey() {
        return this.name;
    }

    @Override
    public NbtData save(SaveObject objectToSave) {
        if (objectToSave == null) {
            return null;
        }
        return (NbtData)((NBTBase)this.save.apply(objectToSave));
    }

    @Override
    public void load(SaveObject objectToLoad, NbtData save) {
        this.load.accept(objectToLoad, save);
    }
}

