/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.saving;

import icbm.classic.lib.saving.NbtSaveRoot;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NbtSaveHandler<E> {
    private static final String ROOT_KEY = "root";
    private final List<NbtSaveRoot<E>> roots = new LinkedList<NbtSaveRoot<E>>();
    private final NbtSaveRoot<E> mainRoot = new NbtSaveRoot("root", this, null);

    public NBTTagCompound save(E objectToSave) {
        return this.save(objectToSave, new NBTTagCompound());
    }

    public NBTTagCompound save(E objectToSave, NBTTagCompound save) {
        this.roots.forEach(root -> {
            NBTTagCompound saveData = root.save(objectToSave);
            if (saveData != null && !saveData.func_82582_d()) {
                save.func_74782_a(root.getSaveKey(), (NBTBase)saveData);
            }
        });
        this.mainRoot.save(objectToSave, save);
        return save;
    }

    public void load(E objectToLoad, NBTTagCompound save) {
        if (save != null && !save.func_82582_d()) {
            this.roots.forEach(root -> {
                if (save.func_74764_b(root.getSaveKey())) {
                    root.load(objectToLoad, save.func_74775_l(root.getSaveKey()));
                }
            });
            this.mainRoot.load(objectToLoad, save);
        }
    }

    public NbtSaveRoot<E> addRoot(String name) {
        NbtSaveRoot root = new NbtSaveRoot(name, this, null);
        this.roots.add(root);
        return root;
    }

    public NbtSaveRoot<E> mainRoot() {
        return this.mainRoot;
    }
}

