/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radar;

import com.google.common.collect.Lists;
import icbm.classic.ICBMClassic;
import icbm.classic.lib.radar.RadarEntity;
import icbm.classic.lib.radar.RadarMap;
import icbm.classic.lib.transform.region.Cube;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class RadarRegistry {
    public static final RadarRegistry INSTANCE = new RadarRegistry();
    private static final HashMap<Integer, RadarMap> RADAR_MAPS = new HashMap();

    public static boolean add(Entity entity) {
        if (entity != null && !entity.field_70128_L && entity.field_70170_p != null && !entity.field_70170_p.field_72995_K) {
            RadarMap map = RadarRegistry.getRadarMapForWorld(entity.field_70170_p);
            return map != null && RadarRegistry.getRadarMapForWorld(entity.field_70170_p).add(entity);
        }
        return false;
    }

    public static boolean remove(Entity entity) {
        if (entity != null && !entity.field_70128_L && entity.field_70170_p != null) {
            RadarMap map = RadarRegistry.getRadarMapForWorld(entity.field_70170_p);
            return map != null ? RadarRegistry.getRadarMapForWorld(entity.field_70170_p).remove(entity) : false;
        }
        return false;
    }

    public static RadarMap getRadarMapForWorld(World world) {
        if (world != null && world.field_73011_w != null) {
            if (world.field_72995_K) {
                if (ICBMClassic.runningAsDev) {
                    ICBMClassic.logger().error("RadarRegistry: Radar data can not be requested client side.", (Throwable)new RuntimeException());
                }
                return null;
            }
            return RadarRegistry.getRadarMapForDim(world.field_73011_w.getDimension());
        }
        if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("RadarRegistry: World can not be null or have a null provider when requesting a radar map", (Throwable)new RuntimeException());
        }
        return null;
    }

    public static RadarMap getRadarMapForDim(int dimID) {
        if (!RADAR_MAPS.containsKey(dimID)) {
            RadarMap map = new RadarMap(dimID);
            RADAR_MAPS.put(dimID, map);
            return map;
        }
        return RADAR_MAPS.get(dimID);
    }

    public static List<Entity> getAllLivingObjectsWithin(World world, double x, double y, double z, double distance) {
        return RadarRegistry.getAllLivingObjectsWithin(world, new Cube(x - distance, 0.0, z - distance, x + distance, 255.0, z + distance));
    }

    public static List<Entity> getAllLivingObjectsWithin(World world, Cube cube) {
        ArrayList list = Lists.newArrayList();
        if (RADAR_MAPS.containsKey(world.field_73011_w.getDimension())) {
            RadarMap map = RadarRegistry.getRadarMapForWorld(world);
            if (map != null) {
                List<RadarEntity> objects = map.getRadarObjects(cube, true);
                for (RadarEntity object : objects) {
                    Entity entity;
                    if (object == null || !object.isValid() || (entity = object.entity) == null || entity.field_70128_L) continue;
                    list.add(entity);
                }
            } else if (world.field_72995_K && ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("RadarRegistry: Radar data can not be requested client side.", (Throwable)new RuntimeException());
            }
        }
        return list;
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        int dim;
        if (event.getChunk().func_177412_p() != null && event.getChunk().func_177412_p().field_73011_w != null && RADAR_MAPS.containsKey(dim = event.getChunk().func_177412_p().field_73011_w.getDimension())) {
            RadarRegistry.getRadarMapForDim(dim).remove(event.getChunk());
        }
    }

    @SubscribeEvent
    public void worldUpdateTick(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.world.field_73011_w != null && event.side == Side.SERVER && event.phase == TickEvent.Phase.END && RADAR_MAPS.containsKey(dim = event.world.field_73011_w.getDimension())) {
            RadarMap map = RadarRegistry.getRadarMapForDim(dim);
            if (map.isEmpty()) {
                RADAR_MAPS.remove(dim);
            } else {
                map.update();
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        int dim;
        if (event.getWorld().field_73011_w != null && RADAR_MAPS.containsKey(dim = event.getWorld().field_73011_w.getDimension())) {
            RadarRegistry.getRadarMapForDim(dim).unloadAll();
            RADAR_MAPS.remove(dim);
        }
    }
}

