/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.lambda.entity;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.lambda.PacketCodex;
import icbm.classic.lib.network.lambda.PacketCodexReg;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketLambdaEntity<TARGET>
implements IPacket<PacketLambdaEntity<TARGET>> {
    public static final String ERROR_HANDLING = "unexpected error writing to Entity(%s)\nEntity: %s";
    public static final String ERROR_NOT_SERVER = "Received packet server side but world(%s) is not WorldServer";
    public static final String DEBUG_INVALID = "entity(%s) was invalid\nEntity: %s";
    public static final String DEBUG_WRONG_DIM = "Received packet client side for world(%s) but got world(%s)... ignoring.";
    private PacketCodex<Entity, TARGET> codex;
    private int dimensionId;
    private int entityId;
    private List<Consumer<ByteBuf>> writers;
    private List<Consumer<TARGET>> setters;

    public PacketLambdaEntity(PacketCodex<Entity, TARGET> codex, Entity entity, TARGET target) {
        this.codex = codex;
        this.entityId = entity.func_145782_y();
        this.dimensionId = entity.field_70170_p.field_73011_w.getDimension();
        this.writers = codex.encodeAsWriters(target);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.codex.getId());
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.dimensionId);
        this.writers.forEach(c -> c.accept(buffer));
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int codexId = buffer.readInt();
        this.codex = PacketCodexReg.get(codexId);
        if (this.codex == null) {
            ICBMClassic.logger().error(String.format("PacketEntity: Failed to locate codex(%s)", codexId));
            return;
        }
        this.entityId = buffer.readInt();
        this.dimensionId = buffer.readInt();
        this.setters = this.codex.decodeAsSetters(buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(Minecraft minecraft, EntityPlayer player) {
        int playerDim = player.field_70170_p.field_73011_w.getDimension();
        if (playerDim != this.getDimensionId()) {
            String message = String.format(DEBUG_WRONG_DIM, this.getDimensionId(), playerDim);
            this.codex.logDebug(player.field_70170_p, player.func_180425_c(), message);
            return;
        }
        World world = player.field_70170_p;
        minecraft.func_152344_a(() -> this.loadDataIntoTile(world, player));
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        int playerDim = player.field_70170_p.field_73011_w.getDimension();
        if (playerDim != this.getDimensionId()) {
            String message = String.format(DEBUG_WRONG_DIM, this.getDimensionId(), playerDim);
            this.codex.logDebug(player.field_70170_p, player.func_180425_c(), message);
            return;
        }
        if (!(player.field_70170_p instanceof WorldServer)) {
            String message = String.format(ERROR_NOT_SERVER, this.getDimensionId());
            this.codex.logError(player.field_70170_p, player.func_180425_c(), message);
            return;
        }
        WorldServer world = (WorldServer)player.field_70170_p;
        world.func_152344_a(() -> this.loadDataIntoTile((World)world, player));
    }

    private void loadDataIntoTile(World world, EntityPlayer player) {
        Entity entity = null;
        try {
            entity = player.field_70170_p.func_73045_a(this.getEntityId());
            if (entity != null && this.codex.isValid(entity)) {
                Object target = this.codex.getConverter().apply(entity);
                if (target != null) {
                    this.setters.forEach(c -> c.accept(target));
                }
                if (this.codex.onFinished() != null) {
                    this.codex.onFinished().accept((Object)entity, target, (Object)player);
                }
            } else if (ICBMClassic.logger().isDebugEnabled()) {
                this.codex.logDebug(world, Optional.ofNullable(entity).map(Entity::func_180425_c).orElse(null), String.format(DEBUG_INVALID, this.getEntityId(), entity));
            }
        }
        catch (Exception e) {
            this.codex.logError(world, Optional.ofNullable(entity).map(Entity::func_180425_c).orElse(null), String.format(ERROR_HANDLING, this.getEntityId(), entity), e);
        }
    }

    @Generated
    public PacketCodex<Entity, TARGET> getCodex() {
        return this.codex;
    }

    @Generated
    public int getDimensionId() {
        return this.dimensionId;
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public List<Consumer<ByteBuf>> getWriters() {
        return this.writers;
    }

    @Generated
    public List<Consumer<TARGET>> getSetters() {
        return this.setters;
    }

    @Generated
    public void setCodex(PacketCodex<Entity, TARGET> codex) {
        this.codex = codex;
    }

    @Generated
    public void setDimensionId(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    @Generated
    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setWriters(List<Consumer<ByteBuf>> writers) {
        this.writers = writers;
    }

    @Generated
    public void setSetters(List<Consumer<TARGET>> setters) {
        this.setters = setters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketLambdaEntity)) {
            return false;
        }
        PacketLambdaEntity other = (PacketLambdaEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimensionId() != other.getDimensionId()) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        PacketCodex<Entity, TARGET> this$codex = this.getCodex();
        PacketCodex<Entity, TARGET> other$codex = other.getCodex();
        if (this$codex == null ? other$codex != null : !((Object)this$codex).equals(other$codex)) {
            return false;
        }
        List<Consumer<ByteBuf>> this$writers = this.getWriters();
        List<Consumer<ByteBuf>> other$writers = other.getWriters();
        if (this$writers == null ? other$writers != null : !((Object)this$writers).equals(other$writers)) {
            return false;
        }
        List<Consumer<TARGET>> this$setters = this.getSetters();
        List<Consumer<TARGET>> other$setters = other.getSetters();
        return !(this$setters == null ? other$setters != null : !((Object)this$setters).equals(other$setters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketLambdaEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimensionId();
        result = result * 59 + this.getEntityId();
        PacketCodex<Entity, TARGET> $codex = this.getCodex();
        result = result * 59 + ($codex == null ? 43 : ((Object)$codex).hashCode());
        List<Consumer<ByteBuf>> $writers = this.getWriters();
        result = result * 59 + ($writers == null ? 43 : ((Object)$writers).hashCode());
        List<Consumer<TARGET>> $setters = this.getSetters();
        result = result * 59 + ($setters == null ? 43 : ((Object)$setters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PacketLambdaEntity(codex=" + this.getCodex() + ", dimensionId=" + this.getDimensionId() + ", entityId=" + this.getEntityId() + ", writers=" + this.getWriters() + ", setters=" + this.getSetters() + ")";
    }

    @Generated
    public PacketLambdaEntity() {
    }
}

