/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.lambda.entity;

import icbm.classic.lib.network.lambda.PacketCodex;
import icbm.classic.lib.network.lambda.entity.PacketLambdaEntity;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class PacketCodexEntity<R extends Entity, T>
extends PacketCodex<R, T> {
    public PacketCodexEntity(ResourceLocation parent, String name, Function<R, T> converter) {
        this(parent, new ResourceLocation("icbmclassic", name), converter);
    }

    public PacketCodexEntity(ResourceLocation parent, ResourceLocation name, Function<R, T> converter) {
        super(parent, name, converter);
    }

    public PacketCodexEntity(ResourceLocation parent, ResourceLocation name) {
        this(parent, name, (R tile) -> tile);
    }

    public PacketCodexEntity(ResourceLocation parent, String name) {
        this(parent, new ResourceLocation("icbmclassic", name));
    }

    public void sendToAllAround(R tile) {
        double range = 200.0;
        if (((Entity)tile).field_70170_p instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)((Entity)tile).field_70170_p;
            range = Optional.ofNullable(worldServer.func_73046_m()).map(MinecraftServer::func_184103_al).map(PlayerList::func_72395_o).map(d -> (double)(d * 16) + 1.0).orElse(range);
        }
        this.sendToAllAround(tile, range);
    }

    public void sendToAllAround(R tile, double range) {
        super.sendToAllAround(tile, new NetworkRegistry.TargetPoint(((Entity)tile).field_70170_p.field_73011_w.getDimension(), ((Entity)tile).field_70165_t, ((Entity)tile).field_70163_u, ((Entity)tile).field_70161_v, range));
    }

    @Override
    public boolean isValid(Entity tile) {
        return tile != null && tile.func_70089_S();
    }

    public PacketLambdaEntity<T> build(R tile) {
        return new PacketLambdaEntity(this, (Entity)tile, this.getConverter().apply(tile));
    }
}

