/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive.reg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.reg.content.IExplosiveContentRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public abstract class ExplosiveContentRegistry
implements IExplosiveContentRegistry {
    public final ResourceLocation name;
    private boolean locked = false;
    private Set<Integer> idCache;
    private Set<ResourceLocation> nameCache = new HashSet<ResourceLocation>();
    private Set<IExplosiveData> dataCache;
    private Map<ResourceLocation, IExplosiveData> mapCache;

    public ExplosiveContentRegistry(ResourceLocation name) {
        this.name = name;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    @Override
    public void enableContent(ResourceLocation regName) {
        if (this.locked) {
            throw new RuntimeException(this + ": No content can be registered after registry phase");
        }
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(regName);
        if (!this.nameCache.contains(data)) {
            this.nameCache.add(regName);
        }
    }

    @Override
    public Set<Integer> getExplosivesIDs() {
        return this.idCache;
    }

    @Override
    public Set<ResourceLocation> getExplosiveNames() {
        return this.nameCache;
    }

    @Override
    public Set<IExplosiveData> getExplosives() {
        return this.dataCache;
    }

    @Override
    public void lockRegistry() {
        HashMap<ResourceLocation, IExplosiveData> map;
        if (!this.locked) {
            this.locked = true;
            this.nameCache = ImmutableSet.copyOf(this.nameCache);
            map = new HashMap<ResourceLocation, IExplosiveData>();
            for (ResourceLocation name : this.nameCache) {
                IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(name);
                if (data != null) {
                    map.put(name, data);
                    continue;
                }
                throw new RuntimeException(this + ": Failed to locate explosive by name " + name);
            }
        } else {
            throw new RuntimeException(this + ": Registry was locked twice!");
        }
        this.mapCache = ImmutableMap.copyOf(map);
        this.idCache = (Set)map.values().stream().map(entry -> entry.getRegistryID()).collect(ImmutableSet.toImmutableSet());
        this.dataCache = (Set)map.values().stream().collect(ImmutableSet.toImmutableSet());
    }

    public String toString() {
        return "ExplosiveContentRegistry[" + this.name + "]";
    }

    public boolean isLocked() {
        return this.locked;
    }
}

