/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive.reg;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.data.BlockActivateFunction;
import icbm.classic.api.data.WorldPosIntSupplier;
import icbm.classic.api.data.WorldTickFunction;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.reg.content.IExBlockRegistry;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.lib.explosive.reg.ExplosiveContentRegistry;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ExBlockContentReg
extends ExplosiveContentRegistry
implements IExBlockRegistry {
    private final HashMap<ResourceLocation, WorldPosIntSupplier> fuseSetSupplierMap = new HashMap();
    private final HashMap<ResourceLocation, WorldTickFunction> fuseTickCallbackMap = new HashMap();
    private final HashMap<ResourceLocation, BlockActivateFunction> blockActivationCallbackMap = new HashMap();
    private final IntHashMap<WorldPosIntSupplier> fuseSetSupplier = new IntHashMap();
    private final IntHashMap<WorldTickFunction> fuseTickCallback = new IntHashMap();
    private final IntHashMap<BlockActivateFunction> blockActiviationCallback = new IntHashMap();

    public ExBlockContentReg() {
        super(ICBMClassicAPI.EX_BLOCK);
    }

    @Override
    public ItemStack getDeviceStack(ResourceLocation regName) {
        return new ItemStack(BlockReg.blockExplosive, 1, ICBMClassicHelpers.getExplosive(regName, false).getRegistryID());
    }

    @Override
    public void lockRegistry() {
        if (this.isLocked()) {
            throw new RuntimeException(this + ": Registry was locked twice!");
        }
        super.lockRegistry();
        this.fuseSetSupplierMap.forEach((regName, func) -> {
            IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData((ResourceLocation)regName);
            if (data != null) {
                this.fuseSetSupplier.func_76038_a(data.getRegistryID(), func);
            }
        });
        this.fuseTickCallbackMap.forEach((regName, func) -> {
            IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData((ResourceLocation)regName);
            if (data != null) {
                this.fuseTickCallback.func_76038_a(data.getRegistryID(), func);
            }
        });
        this.blockActivationCallbackMap.forEach((regName, func) -> {
            IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData((ResourceLocation)regName);
            if (data != null) {
                this.blockActiviationCallback.func_76038_a(data.getRegistryID(), func);
            }
        });
    }

    @Override
    public void setFuseSupplier(ResourceLocation exName, WorldPosIntSupplier fuseTimer) {
        this.fuseSetSupplierMap.put(exName, fuseTimer);
    }

    @Override
    public void setFuseTickListener(ResourceLocation exName, WorldTickFunction function) {
        this.fuseTickCallbackMap.put(exName, function);
    }

    @Override
    public void setActivationListener(ResourceLocation exName, BlockActivateFunction function) {
        this.blockActivationCallbackMap.put(exName, function);
    }

    @Override
    public void tickFuse(World world, double posX, double posY, double posZ, int ticksExisted, int explosiveID) {
        WorldTickFunction function = (WorldTickFunction)this.fuseTickCallback.func_76041_a(explosiveID);
        if (function != null) {
            function.onTick(world, posX, posY, posZ, ticksExisted);
        }
    }

    @Override
    public int getFuseTime(World world, double posX, double posY, double posZ, int explosiveID) {
        WorldPosIntSupplier function = (WorldPosIntSupplier)this.fuseSetSupplier.func_76041_a(explosiveID);
        if (function != null) {
            return function.get(world, posX, posY, posZ);
        }
        return 100;
    }
}

