/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.ex;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.reg.IExplosiveCustomization;
import icbm.classic.api.reg.IExplosiveData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityExplosiveStack
implements IExplosive,
ICapabilitySerializable<NBTTagCompound> {
    private final ItemStack stack;
    private final List<IExplosiveCustomization> customizationList = new ArrayList<IExplosiveCustomization>();

    public CapabilityExplosiveStack(ItemStack stack) {
        this.stack = stack;
    }

    protected int getExplosiveID() {
        if (this.stack == null) {
            return 0;
        }
        return this.stack.func_77952_i();
    }

    @Override
    @Nullable
    public IExplosiveData getExplosiveData() {
        return ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(this.getExplosiveID());
    }

    @Override
    public void applyCustomizations(IBlast blast) {
        this.customizationList.forEach(c -> c.apply(this.getExplosiveData(), blast));
    }

    @Override
    public void addCustomization(IExplosiveCustomization customization) {
        this.customizationList.add(customization);
    }

    @Override
    public void collectInformation(Consumer<String> collector) {
        this.customizationList.forEach(c -> c.collectCustomizationInformation(collector));
    }

    @Override
    @Nullable
    public ItemStack toStack() {
        if (this.stack == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack re = this.stack.func_77946_l();
        re.func_190920_e(1);
        return re;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound save = new NBTTagCompound();
        save.func_74782_a("customizations", (NBTBase)ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY.save(this.customizationList));
        return save;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("customizations")) {
            ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY.load(nbt.func_150295_c("customizations", 10), this.customizationList);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)ICBMClassicAPI.EXPLOSIVE_CAPABILITY.cast((Object)this);
        }
        return null;
    }
}

