/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.buildable;

import icbm.classic.api.reg.obj.IBuildableObject;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.lib.saving.NbtSaveHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class BuildableObject<T extends IBuildableObject, B extends IBuilderRegistry>
implements IBuildableObject {
    @Nonnull
    private final ResourceLocation registryKey;
    @Nonnull
    private final B registry;
    @Nullable
    private final NbtSaveHandler<T> saveHandler;

    public BuildableObject(@Nonnull ResourceLocation registryKey, @Nonnull B registry, @Nullable NbtSaveHandler<T> saveHandler) {
        this.registryKey = registryKey;
        this.registry = registry;
        this.saveHandler = saveHandler;
    }

    public NBTTagCompound serializeNBT() {
        return this.saveHandler != null ? this.saveHandler.save(this) : null;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.saveHandler != null) {
            this.saveHandler.load(this, nbt);
        }
    }

    @Override
    @Nonnull
    @Generated
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    @Nonnull
    @Generated
    public B getRegistry() {
        return this.registry;
    }

    @Nullable
    @Generated
    protected NbtSaveHandler<T> getSaveHandler() {
        return this.saveHandler;
    }
}

