/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.content.blast.Blast;
import icbm.classic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class WorkTickingActionHandler {
    public static final ArrayList<IBlast> activeBlasts = new ArrayList();

    public static void add(Blast blast) {
        activeBlasts.add(blast);
    }

    public static void remove(Blast blast) {
        activeBlasts.remove(blast);
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && !activeBlasts.isEmpty()) {
            int dim = event.getWorld().field_73011_w.getDimension();
            activeBlasts.stream().filter(blast -> blast != null && (blast.world() == null || blast.world().field_73011_w.getDimension() == dim)).forEach(IBlast::clearBlast);
        }
    }

    public static int removeNear(World world, double x, double y, double z, double range) {
        Pos pos = new Pos(x, y, z);
        List<IBlast> toRemove = activeBlasts.stream().filter(blast -> blast.world() == world).filter(blast -> range < 0.0 || range > 0.0 && range > pos.distance((IPos3D)blast)).collect(Collectors.toList());
        activeBlasts.removeAll(toRemove);
        toRemove.forEach(IBlast::clearBlast);
        return toRemove.size();
    }
}

