/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.IPotentialAction;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.conditions.ICondition;
import icbm.classic.api.actions.conditions.IConditionCause;
import icbm.classic.api.actions.data.IActionFieldProvider;
import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.CausedByBlock;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.tile.ITick;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class PotentialActionImp<SELF extends PotentialActionImp<SELF>>
implements IPotentialAction,
ITick,
INBTSerializable<NBTTagCompound> {
    private ICondition preCheck;
    private IActionFieldProvider fieldProvider;
    private static final NbtSaveHandler<PotentialActionImp> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeBuildableObject("pre_check", () -> ICBMClassicAPI.CONDITION_REGISTRY, PotentialActionImp::getPreCheck, PotentialActionImp::setPreCheck).base();

    public SELF withCondition(ICondition check) {
        this.preCheck = check;
        if (check != null) {
            check.init(this.fieldProvider);
        }
        return (SELF)this;
    }

    public SELF withProvider(IActionFieldProvider provider) {
        this.fieldProvider = provider;
        if (this.preCheck != null) {
            this.preCheck.init(this.fieldProvider);
        }
        return (SELF)this;
    }

    @Override
    @Nonnull
    public IActionStatus checkAction(World world, double x, double y, double z, @Nullable IActionCause cause) {
        if (this.getActionData() == null) {
            return ActionResponses.MISSING_ACTION_DATA;
        }
        return this.preCheck == null ? ActionResponses.READY : this.preCheck.getCondition();
    }

    public IActionStatus doAction(TileEntity tile, @Nullable IActionCause cause) {
        IActionCause selfCause = new CausedByBlock(tile.func_145831_w(), tile.func_174877_v(), tile.func_145831_w().func_180495_p(tile.func_174877_v())).setPreviousCause(cause);
        return this.doAction(tile.func_145831_w(), tile.func_174877_v(), selfCause);
    }

    public IActionStatus doAction(World world, BlockPos pos, @Nullable IActionCause cause) {
        return this.doAction(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, cause);
    }

    @Override
    @Nonnull
    public IActionStatus doAction(World world, double x, double y, double z, @Nullable IActionCause cause) {
        IActionData actionData = this.getActionData();
        if (actionData == null) {
            return ActionResponses.MISSING_ACTION_DATA;
        }
        IActionStatus preCheckStatus = this.checkAction(world, x, y, z, cause);
        if (preCheckStatus.isType(ActionStatusTypes.BLOCKING)) {
            return preCheckStatus;
        }
        IActionCause causeToUse = cause;
        if (this.preCheck != null) {
            IActionCause preCheckCause;
            if (this.preCheck instanceof IConditionCause && (preCheckCause = ((IConditionCause)this.preCheck).getCause()) != null) {
                causeToUse = preCheckCause.setPreviousCause(cause);
            }
            this.preCheck.reset();
        }
        ActionSource actionSource = new ActionSource(world, new Vec3d(x, y, z), causeToUse);
        return ICBMClassicAPI.ACTION_LISTENER.runAction(actionData.create(world, x, y, z, actionSource, this.fieldProvider));
    }

    @Override
    public void update(int tick, boolean isServer) {
        if (isServer && this.preCheck != null) {
            this.preCheck.onTick();
        }
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public ICondition getPreCheck() {
        return this.preCheck;
    }

    @Generated
    private void setPreCheck(ICondition preCheck) {
        this.preCheck = preCheck;
    }

    @Generated
    public IActionFieldProvider getFieldProvider() {
        return this.fieldProvider;
    }

    @Generated
    public void setFieldProvider(IActionFieldProvider fieldProvider) {
        this.fieldProvider = fieldProvider;
    }
}

