/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryHelpers {
    public static <V extends IForgeRegistryEntry<V>> boolean contains(IForgeRegistry<V> registry, ResourceLocation targetKey) {
        if (targetKey.func_110623_a().startsWith("~") && targetKey.func_110623_a().endsWith("~")) {
            String checkStr = targetKey.func_110623_a().substring(1, targetKey.func_110623_a().length() - 1);
            return ForgeRegistryHelpers.pathContains(registry, targetKey.func_110624_b(), checkStr);
        }
        if (targetKey.func_110623_a().startsWith("~")) {
            String checkStr = targetKey.func_110623_a().substring(1);
            return ForgeRegistryHelpers.pathEndsWith(registry, targetKey.func_110624_b(), checkStr);
        }
        if (targetKey.func_110623_a().endsWith("~")) {
            String checkStr = targetKey.func_110623_a().substring(0, targetKey.func_110623_a().length() - 1);
            return ForgeRegistryHelpers.pathStartsWith(registry, targetKey.func_110624_b(), checkStr);
        }
        return registry.containsKey(targetKey) && registry.getValue(targetKey) != null;
    }

    private static <V extends IForgeRegistryEntry<V>> boolean pathContains(IForgeRegistry<V> registry, String domain, String checkStr) {
        return registry.getKeys().stream().anyMatch(contentKey -> contentKey.func_110624_b().equalsIgnoreCase(domain) && contentKey.func_110623_a().contains(checkStr) && registry.getValue(contentKey) != null);
    }

    private static <V extends IForgeRegistryEntry<V>> boolean pathEndsWith(IForgeRegistry<V> registry, String domain, String checkStr) {
        return registry.getKeys().stream().anyMatch(contentKey -> contentKey.func_110624_b().equalsIgnoreCase(domain) && contentKey.func_110623_a().endsWith(checkStr) && registry.getValue(contentKey) != null);
    }

    private static <V extends IForgeRegistryEntry<V>> boolean pathStartsWith(IForgeRegistry<V> registry, String domain, String checkStr) {
        return registry.getKeys().stream().anyMatch(contentKey -> contentKey.func_110624_b().equalsIgnoreCase(domain) && contentKey.func_110623_a().startsWith(checkStr) && registry.getValue(contentKey) != null);
    }
}

