/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.reg;

import icbm.classic.api.refs.ICBMEntities;
import icbm.classic.content.blast.redmatter.EntityRedmatter;
import icbm.classic.content.cargo.balloon.EntityBalloon;
import icbm.classic.content.cargo.parachute.EntityParachute;
import icbm.classic.content.cluster.bomblet.EntityBombDroplet;
import icbm.classic.content.entity.EntityBombCart;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.entity.EntitySmoke;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import icbm.classic.content.missile.entity.anti.EntitySurfaceToAirMissile;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.entity.explosive.EntityMissileActionable;
import icbm.classic.content.missile.entity.itemstack.EntityHeldItemMissile;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="icbmclassic")
public final class EntityReg {
    private static int nextEntityID = 0;

    @SubscribeEvent
    public static void missingMapping(RegistryEvent.MissingMappings<EntityEntry> event) {
        ResourceLocation oldMissileName = new ResourceLocation("icbmclassic", "missile");
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!oldMissileName.equals((Object)mapping.key)) continue;
            mapping.remap(ForgeRegistries.ENTITIES.getValue(ICBMEntities.MISSILE_EXPLOSIVE));
        }
    }

    @SubscribeEvent
    public static void registerEntity(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityFlyingBlock.class, ICBMEntities.BLOCK_GRAVITY, 128, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityFragments.class, ICBMEntities.BLOCK_FRAGMENT, 40, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityExplosive.class, ICBMEntities.BLOCK_EXPLOSIVE, 50, 5));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityExplosiveMissile.class, ICBMEntities.MISSILE_EXPLOSIVE, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityMissileActionable.class, ICBMEntities.MISSILE_GENERIC, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntitySurfaceToAirMissile.class, ICBMEntities.MISSILE_SAM, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityHeldItemMissile.class, ICBMEntities.MISSILE_HELD_ITEM, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityExplosion.class, ICBMEntities.EXPLOSION, 100, 5));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityLightBeam.class, ICBMEntities.BEAM, 80, 5));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityGrenade.class, ICBMEntities.GRENADE, 50, 5));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityBombCart.class, ICBMEntities.BOMB_CART, 50, 2));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityPlayerSeat.class, ICBMEntities.MISSILE_SEAT, 50, 2));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityRedmatter.class, ICBMEntities.REDMATTER, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntitySmoke.class, ICBMEntities.SMOKE, 100, 15));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityBombDroplet.class, ICBMEntities.BOMB_DROPLET, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityParachute.class, ICBMEntities.PARACHUTE, 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)EntityReg.buildEntityEntry(EntityBalloon.class, ICBMEntities.BALLOON, 500, 1));
    }

    private static EntityEntry buildEntityEntry(Class<? extends Entity> entityClass, ResourceLocation name, int trackingRange, int updateFrequency) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.name(name.toString());
        builder.id(name, nextEntityID++);
        builder.tracker(trackingRange, updateFrequency, true);
        builder.entity(entityClass);
        return builder.build();
    }
}

