/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.radioactive;

import com.google.common.collect.Lists;
import icbm.classic.ICBMClassic;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.blocks.ConfigBlocks;
import icbm.classic.content.gas.ProtectiveArmorHandler;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRadioactive
extends Block {
    public static final PropertyType TYPE_PROP = new PropertyType();
    public static final DamageSource damageSource = new DamageSource("icbmclassic:radioactive_block");

    public BlockRadioactive() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TYPE_PROP, (Comparable)((Object)EnumType.STONE)));
        this.setRegistryName("icbmclassic:radioactive");
        this.func_149663_c("icbmclassic:radioactive");
        this.func_149647_a(ICBMClassic.CREATIVE_TAB);
        this.func_149711_c(0.5f);
        if (ConfigBlocks.radioactive.decayDelay > 0) {
            this.func_149675_a(true);
        }
    }

    public int func_149738_a(@Nonnull World worldIn) {
        return ConfigBlocks.radioactive.decayDelay;
    }

    public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        this.func_180650_b(worldIn, pos, state, random);
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        if (!worldIn.field_72995_K) {
            boolean stop = this.tryDecaySelf(worldIn, pos, state, random);
            this.tryDecayEntities(worldIn, pos, state, random);
            if (!stop && !ConfigBlocks.radioactive.randomTickOnly) {
                worldIn.func_175684_a(pos, (Block)this, random.nextInt(this.func_149738_a(worldIn)) + 1);
            }
        }
    }

    private boolean tryDecaySelf(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if ((double)ConfigBlocks.radioactive.decayBlockChance <= 1.0E-9) {
            return false;
        }
        if (random.nextFloat() < ConfigBlocks.radioactive.decayBlockChance) {
            this.doDecaySelf(worldIn, pos, state);
            return true;
        }
        return false;
    }

    private void doDecaySelf(World worldIn, BlockPos pos, IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b((IProperty)TYPE_PROP))) {
            case DIRT: {
                worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                break;
            }
            case STONE: {
                worldIn.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
                break;
            }
        }
    }

    private void tryDecayEntities(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (ConfigBlocks.radioactive.decayEffectRange <= 0 || ConfigBlocks.radioactive.decayEffectChance <= 0.0f) {
            return;
        }
        AxisAlignedBB bounds = new AxisAlignedBB(pos).func_72314_b((double)ConfigBlocks.radioactive.decayEffectRange, (double)ConfigBlocks.radioactive.decayEffectRange, (double)ConfigBlocks.radioactive.decayEffectRange);
        List entities = worldIn.func_72872_a(EntityLivingBase.class, bounds);
        for (EntityLivingBase entity : entities) {
            float protection;
            if (!(random.nextFloat() < ConfigBlocks.radioactive.decayEffectChance) || !((protection = ProtectiveArmorHandler.getProtectionRating(entity)) < ConfigMain.protectiveArmor.minProtectionRadiation) && !(protection < random.nextFloat())) continue;
            entity.func_70097_a(damageSource, ConfigBlocks.radioactive.decayEffectDamage);
            if (ConfigBlocks.radioactive.decayWitherDuration <= 0) continue;
            entity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 20));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (rand.nextInt(12) == 0) {
            ICBMSounds.RADIOACTIVE_TICK.play(worldIn, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 1.0f + rand.nextFloat() * 0.5f, 1.0f + rand.nextFloat() * 0.2f, true);
        }
    }

    @Deprecated
    public float func_176195_g(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        if (blockState.func_177228_b().containsKey((Object)TYPE_PROP)) {
            EnumType type = (EnumType)((Object)blockState.func_177228_b().get((Object)TYPE_PROP));
            switch (type) {
                case DIRT: {
                    return Blocks.field_150346_d.func_176195_g(Blocks.field_150346_d.func_176223_P(), worldIn, pos);
                }
                case STONE: {
                    return Blocks.field_150348_b.func_176195_g(Blocks.field_150348_b.func_176223_P(), worldIn, pos);
                }
            }
        }
        return this.field_149782_v;
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177228_b().containsKey((Object)TYPE_PROP)) {
            EnumType type = (EnumType)((Object)blockState.func_177228_b().get((Object)TYPE_PROP));
            switch (type) {
                case DIRT: {
                    return Blocks.field_150346_d.getExplosionResistance(world, pos, exploder, explosion);
                }
                case STONE: {
                    return Blocks.field_150348_b.getExplosionResistance(world, pos, exploder, explosion);
                }
            }
        }
        return this.func_149638_a(exploder);
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_PROP});
    }

    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE_PROP, (Comparable)((Object)EnumType.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)TYPE_PROP))).ordinal();
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE_PROP, (Comparable)((Object)EnumType.get(meta)));
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab == this.func_149708_J()) {
            for (EnumType type : EnumType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        DIRT,
        STONE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static EnumType get(int meta) {
            return meta >= 0 && meta < EnumType.values().length ? EnumType.values()[meta] : STONE;
        }
    }

    public static class PropertyType
    extends PropertyEnum<EnumType> {
        public PropertyType() {
            super("type", EnumType.class, (Collection)Lists.newArrayList((Object[])EnumType.values()));
        }
    }
}

