/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.explosive;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.lib.actions.PotentialAction;
import icbm.classic.lib.actions.fields.ActionFieldProvider;
import icbm.classic.lib.saving.NbtSaveHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class EntityMissileActionable
extends EntityMissile<EntityMissileActionable> {
    private final PotentialAction mainAction = (PotentialAction)new PotentialAction().withProvider(new ActionFieldProvider().field(ActionFields.IMPACTED, () -> this.hasImpacted).field(ActionFields.HOST_ENTITY, () -> this).field(ActionFields.HOST_POSITION, () -> ((EntityMissileActionable)this).func_174791_d()).field(ActionFields.TARGET_POSITION, () -> this.getMissileCapability().getTargetData() != null ? this.getMissileCapability().getTargetData().getPosition() : null));
    private ItemStack originalStack = ItemStack.field_190927_a;
    private static final NbtSaveHandler<EntityMissileActionable> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("potential_action", EntityMissileActionable::getMainAction).nodeItemStack("original_stack", EntityMissileActionable::getOriginalStack, EntityMissileActionable::setOriginalStack).base();

    public EntityMissileActionable(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissileActionable setActionData(IActionData actionData) {
        this.mainAction.setActionData(actionData);
        return this;
    }

    @Override
    protected void onDestroyedBy(DamageSource source, float damage) {
        IActionStatus status;
        if ((source.func_94541_c() || source.func_76347_k()) && !(status = this.mainAction.doAction(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, new EntityCause(this))).isType(ActionStatusTypes.BLOCKING)) {
            super.onDestroyedBy(source, damage);
        }
    }

    public String func_70005_c_() {
        IActionData data = this.mainAction.getActionData();
        if (data != null) {
            return I18n.func_74838_a((String)("missile." + data.getRegistryKey().toString() + ".name"));
        }
        return I18n.func_74838_a((String)"missile.icbmclassic:generic.name");
    }

    @Override
    public void writeSpawnData(ByteBuf additionalMissileData) {
        NBTTagCompound saveData = SAVE_LOGIC.save(this, new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)additionalMissileData, (NBTTagCompound)saveData);
        super.writeSpawnData(additionalMissileData);
    }

    @Override
    public void readSpawnData(ByteBuf additionalMissileData) {
        NBTTagCompound saveData = ByteBufUtils.readTag((ByteBuf)additionalMissileData);
        SAVE_LOGIC.load(this, saveData);
        super.readSpawnData(additionalMissileData);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.mainAction.update(this.field_70173_aa, !this.func_130014_f_().field_72995_K);
        IActionStatus status = this.mainAction.doAction(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, new EntityCause(this));
        if (!status.isType(ActionStatusTypes.BLOCKING)) {
            this.destroy();
        }
    }

    @Override
    public boolean func_184230_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (ICBMClassicAPI.EX_MISSILE_REGISTRY.onInteraction(this, player, hand)) {
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    protected void actionOnImpact(RayTraceResult impactLocation) {
        IActionStatus status = this.mainAction.doAction(this.func_130014_f_(), impactLocation.field_72307_f.field_72450_a, impactLocation.field_72307_f.field_72448_b, impactLocation.field_72307_f.field_72449_c, new EntityCause(this));
        if (!status.isType(ActionStatusTypes.BLOCKING)) {
            super.actionOnImpact(impactLocation);
        }
    }

    @Override
    public ItemStack toStack() {
        return this.originalStack;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        SAVE_LOGIC.save(this, nbt);
    }

    @Generated
    public PotentialAction getMainAction() {
        return this.mainAction;
    }

    @Generated
    public ItemStack getOriginalStack() {
        return this.originalStack;
    }

    @Generated
    public EntityMissileActionable setOriginalStack(ItemStack originalStack) {
        this.originalStack = originalStack;
        return this;
    }
}

