/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.IMissileAiming;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.cluster.action.ActionDataCluster;
import icbm.classic.content.missile.entity.explosive.EntityMissileActionable;
import icbm.classic.content.missile.logic.flight.ArcFlightLogic;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import icbm.classic.content.missile.logic.flight.move.MoveByVec3Logic;
import icbm.classic.content.missile.logic.flight.prefab.AccelerateByVec3Logic;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.lib.actions.PotentialAction;
import icbm.classic.prefab.item.ItemICBMElectrical;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRocketLauncher
extends ItemICBMElectrical {
    private static final int ENERGY = 1000000;
    private static final int firingDelay = 1000;
    private final HashMap<String, Long> clickTimePlayer = new HashMap();
    private static final double minDistance = 20.0;
    private static final double ballisticBurstY = 20.0;
    private final boolean fireUpDown;

    public ItemRocketLauncher(boolean fireUpDown) {
        super(fireUpDown ? "ballisticLauncher" : "rocketLauncher");
        this.fireUpDown = fireUpDown;
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase shooter, int timeLeft) {
        if (!(shooter instanceof EntityPlayer)) return;
        EntityPlayer player = (EntityPlayer)shooter;
        if (this.getEnergy(stack) < 1000000 && !player.field_71075_bZ.field_75098_d) return;
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ICapabilityMissileStack capabilityMissileStack;
            ItemStack inventoryStack = player.field_71071_by.func_70301_a(slot);
            if (!inventoryStack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null) || (capabilityMissileStack = (ICapabilityMissileStack)inventoryStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) == null) continue;
            if (!world.field_72995_K) {
                IMissile missile = capabilityMissileStack.newMissile(world);
                Entity missileEntity = missile.getMissileEntity();
                if (missileEntity instanceof IMissileAiming) {
                    PotentialAction potentialAction;
                    ((IMissileAiming)missileEntity).initAimingPosition((Entity)player, 1.0f, ConfigMissile.DIRECT_FLIGHT_SPEED);
                    Vec3d eyePos = player.func_174824_e(1.0f);
                    Vec3d lookVector = player.func_70676_i(1.0f);
                    if (this.fireUpDown) {
                        AccelerateByVec3Logic stepLockHeight = new MoveByVec3Logic().setDistance(3.0).setRelative(false).setDirection(lookVector).setAcceleration(0.2);
                        missile.setFlightLogic(stepLockHeight.addStep(new ArcFlightLogic()));
                    } else {
                        missile.setFlightLogic(new DeadFlightLogic(ConfigMissile.HANDHELD_FUEL));
                    }
                    missile.setMissileSource(new ActionSource(world, missileEntity.func_174791_d(), new EntityCause((Entity)player)));
                    double traceDistance = 500.0;
                    Vec3d rayEnd = eyePos.func_72441_c(lookVector.field_72450_a * 500.0, lookVector.field_72448_b * 500.0, lookVector.field_72449_c * 500.0);
                    RayTraceResult rayTraceResult = world.func_147447_a(eyePos, rayEnd, false, true, false);
                    if (rayTraceResult != null && rayTraceResult.field_72307_f != null) {
                        if (this.fireUpDown && rayTraceResult.field_72307_f.func_72438_d(player.func_174791_d()) < 20.0) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.icbmclassic:rocketLauncher.error.distance.min", new Object[]{20.0}), true);
                            return;
                        }
                        missile.setTargetData(new BasicTargetData(rayTraceResult.field_72307_f));
                    } else if (this.fireUpDown) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.icbmclassic:rocketLauncher.error.targeting", new Object[0]), true);
                        return;
                    }
                    if (this.fireUpDown && missileEntity instanceof EntityMissileActionable && ((EntityMissileActionable)missileEntity).getMainAction() != null && (potentialAction = ((EntityMissileActionable)missileEntity).getMainAction()).getActionData() instanceof ActionDataCluster) {
                        ((BasicTargetData)missile.getTargetData()).setPosition(missile.getTargetData().getPosition().func_72441_c(0.0, 20.0, 0.0));
                    }
                    missile.launch();
                    if (world.func_72838_d(missileEntity)) {
                        if (player.func_70093_af()) {
                            player.func_184220_m(missileEntity);
                            player.func_70095_a(false);
                        } else if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == Items.field_151058_ca) {
                            double x = shooter.field_70165_t;
                            double y = shooter.field_70163_u;
                            double z = shooter.field_70161_v;
                            for (EntityLiving victim : world.func_72872_a(EntityLiving.class, new AxisAlignedBB(x - 7.0, y - 7.0, z - 7.0, x + 7.0, y + 7.0, z + 7.0))) {
                                if (victim.func_110166_bE() != player) continue;
                                victim.func_184220_m(missileEntity);
                                break;
                            }
                        }
                        if (player.field_71075_bZ.field_75098_d) return;
                        player.field_71071_by.func_70299_a(slot, capabilityMissileStack.consumeMissile());
                        player.field_71069_bz.func_75142_b();
                        this.discharge(stack, 1000000, true);
                        return;
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.icbmclassic:rocketLauncher.error.spawning", new Object[0]), true);
                    }
                    return;
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.icbmclassic:rocketLauncher.error.IMissileAiming", new Object[]{inventoryStack}), true);
                }
                return;
            }
            this.clickTimePlayer.put(player.func_70005_c_(), System.currentTimeMillis());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        long clickMs = System.currentTimeMillis();
        if (this.clickTimePlayer.containsKey(player.func_70005_c_()) && clickMs - this.clickTimePlayer.get(player.func_70005_c_()) < 1000L) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        player.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }
}

