/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IGPSData;
import icbm.classic.api.events.RadarGunTraceEvent;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.capability.gps.CapabilityGPSDataItem;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketPlayerItem;
import icbm.classic.prefab.item.ItemBase;
import icbm.classic.prefab.item.ItemStackCapProvider;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRadarGun
extends ItemBase
implements IPacketIDReceiver {
    public static final double MAX_RANGE = 200.0;

    public ItemRadarGun() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ICBMClassic.CREATIVE_TAB);
        this.func_77655_b("icbmclassic:radarGun");
        this.setRegistryName("icbmclassic", "radarGun");
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        ItemStackCapProvider provider = new ItemStackCapProvider(stack);
        CapabilityGPSDataItem data = new CapabilityGPSDataItem(stack);
        provider.add("gps_data", ICBMClassicAPI.GPS_CAPABILITY, data);
        if (nbt != null && nbt.func_74764_b("linkPos")) {
            NBTTagCompound save = nbt.func_74775_l("linkPos");
            data.setWorld(save.func_74762_e("dimension"));
            data.setPosition(new Vec3d(save.func_74769_h("x"), save.func_74769_h("y"), save.func_74769_h("z")));
            nbt.func_82580_o("linkPos");
        }
        return provider;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        IGPSData gpsData = ICBMClassicHelpers.getGPSData(stack);
        if (gpsData != null && gpsData.getPosition() != null) {
            Vec3d pos = gpsData.getPosition();
            World world = gpsData.getWorld();
            String x = String.format("%.1f", pos.field_72450_a);
            String y = String.format("%.1f", pos.field_72448_b);
            String z = String.format("%.1f", pos.field_72449_c);
            if (world != null) {
                String name = Optional.of(world.func_72912_H()).map(WorldInfo::func_76065_j).orElse("--");
                String worldName = String.format("(%s)%s", world.field_73011_w.getDimension(), name);
                TextComponentTranslation output = new TextComponentTranslation(this.func_77658_a() + ".data.all", new Object[]{x, y, z, worldName});
                LanguageUtility.outputLines((ITextComponent)output, lines::add);
            } else {
                TextComponentTranslation output = new TextComponentTranslation(this.func_77658_a() + ".data.pos", new Object[]{x, y, z});
                LanguageUtility.outputLines((ITextComponent)output, lines::add);
            }
        } else {
            LanguageUtility.outputLines((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".data.empty", new Object[0]), lines::add);
        }
        TextComponentTranslation output = new TextComponentTranslation(this.func_77658_a() + ".info", new Object[]{200.0});
        LanguageUtility.outputLines((ITextComponent)output, lines::add);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack stack = player.func_184586_b(handIn);
                stack.func_77982_d(null);
                stack.func_77964_b(0);
                LanguageUtility.addChatToPlayer(player, "gps.cleared.name");
                player.field_71069_bz.func_75142_b();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
        }
        if (world.field_72995_K) {
            TileEntity tileEntity;
            RayTraceResult objectMouseOver = player.func_174822_a(200.0, 1.0f);
            if (objectMouseOver.field_72313_a != RayTraceResult.Type.MISS && !ICBMClassicHelpers.isLauncher(tileEntity = world.func_175625_s(objectMouseOver.func_178782_a()), null)) {
                this.sendToServer(player, handIn, objectMouseOver.field_72307_f);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af()) {
            stack.func_77982_d(null);
            stack.func_77964_b(0);
            LanguageUtility.addChatToPlayer(player, "gps.cleared.name");
            player.field_71069_bz.func_75142_b();
            return EnumActionResult.SUCCESS;
        }
        if (this.onTrace(new Vec3d((double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitX), (double)((float)pos.func_177952_p() + hitZ)), player, stack)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void sendToServer(EntityPlayer player, EnumHand hand, Vec3d hit) {
        ICBMClassic.packetHandler.sendToServer(((PacketPlayerItem)new PacketPlayerItem(player).addData(new Object[]{hand == EnumHand.MAIN_HAND})).addData(new Object[]{hit}));
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket packet) {
        EnumHand hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        Vec3d pos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        if (player.field_70170_p instanceof WorldServer) {
            ((WorldServer)player.field_70170_p).func_152344_a(() -> this.onTrace(pos, player, player.func_184586_b(hand)));
        }
        return true;
    }

    public boolean onTrace(Vec3d posIn, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() == this) {
            RadarGunTraceEvent event = new RadarGunTraceEvent(player.field_70170_p, posIn, player);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || event.pos == null) {
                return false;
            }
            IGPSData gpsData = ICBMClassicHelpers.getGPSData(stack);
            if (gpsData != null) {
                gpsData.setPosition(posIn);
                gpsData.setWorld(player.field_70170_p);
                LanguageUtility.addChatToPlayer(player, "gps.pos.set.name");
            }
        }
        return true;
    }
}

